////////////////////////////////////////////////////////////////////////////////
// Mercury and Colyseus Software Distribution 
// 
// Copyright (C) 2004-2005 Ashwin Bharambe (ashu@cs.cmu.edu)
//               2004-2005 Jeffrey Pang    (jeffpang@cs.cmu.edu)
//                    2004 Mukesh Agrawal  (mukesh@cs.cmu.edu)
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2, or (at
// your option) any later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA
////////////////////////////////////////////////////////////////////////////////
/* -*- Mode:c++; c-basic-offset:4; tab-width:4; indent-tabs-mode:t -*- */

/**************************************************************************
  TraceEvent.h

begin           : Oct 16, 2003
version         : $Id: TraceEvent.h 2382 2005-11-03 22:54:59Z ashu $
copyright       : (C) 2003      Jeff Pang        ( jeffpang@cs.cmu.edu )
(C) 2003      Justin Weisz     (  jweisz@cs.cmu.edu  )

***************************************************************************/

#ifndef __TRACE_EVENT_H__
#define __TRACE_EVENT_H__

#include <framework2/common.h>
#include <framework2/GObject.h>
#include <framework/TypedAttrValue.h>
#include "WEvent.h"

    typedef enum { EV_INTEREST, EV_MOD, EV_SUB, EV_CREATE, EV_DESTROY } tev_t;

/**
 * An event generated by the workload
 */
class TraceEvent : public WEvent {
 public:

    tev_t type;

    // INTEREST: <origin> is now interested in <interests>
    // MOD:      <origin> made the modification <attributes> to <target>
    //           which is of <size> (<origin> may == <target>)
    // SUB:      <origin> is now subscribed to the space <subs>
    // CREATE:   <origin> created <target> which has properties <properties>
    // DESTROY:  <origin> no longer exists

    GUID origin;
    GUID target;
    AttributeMap attributes;
    size_t size;
    InterestSet subs;
    GUIDVec interests;

    int lineno;

    TraceEvent(gtime_t time, tev_t type);

};

ostream& operator <<(ostream& out, TraceEvent *ev);

#endif
// vim: set sw=4 sts=4 ts=8 noet: 
// Local Variables:
// Mode: c++
// c-basic-offset: 4
// tab-width: 8
// indent-tabs-mode: t
// End:
