////////////////////////////////////////////////////////////////////////////////
// Mercury and Colyseus Software Distribution 
// 
// Copyright (C) 2004-2005 Ashwin Bharambe (ashu@cs.cmu.edu)
//               2004-2005 Jeffrey Pang    (jeffpang@cs.cmu.edu)
//                    2004 Mukesh Agrawal  (mukesh@cs.cmu.edu)
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2, or (at
// your option) any later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA
////////////////////////////////////////////////////////////////////////////////
/* -*- Mode:c++; c-basic-offset:4; tab-width:4; indent-tabs-mode:t -*- */

/**************************************************************************
  TraceEvent.cpp

begin           : Oct 16, 2003
version         : $Id: TraceEvent.cpp 2382 2005-11-03 22:54:59Z ashu $
copyright       : (C) 2003      Jeff Pang        ( jeffpang@cs.cmu.edu )
(C) 2003      Justin Weisz     (  jweisz@cs.cmu.edu  )

***************************************************************************/

#include "TraceEvent.h"

    TraceEvent::TraceEvent(gtime_t time, tev_t type) : 
	WEvent(time, WEvent::TRACE_EVENT), type(type) {
  }

ostream& operator <<(ostream& out, TraceEvent *ev) {
    out << "(TraceEvent lineno=" << ev->lineno << " time=" << ev->time << " type=";
    switch(ev->type) {
    case EV_INTEREST:
	out << "INTEREST";
	out << " guid=" << ev->origin;
	out << " interests=[";
	for (GUIDVecIter i = ev->interests.begin(); 
	     i != ev->interests.end(); i++) {
	    if (i != ev->interests.begin()) out << ",";
	    out << *i;
	}
	out << "]";
	break;
    case EV_MOD:
	out << "MOD";
	out << " origin=" << ev->origin;
	out << " target=" << ev->target;
	out << " size=" << ev->size;
	out << " attrs=[";
	for (AttributeMapIter i = ev->attributes.begin(); 
	     i != ev->attributes.end(); i++) {
	    if (i != ev->attributes.begin()) out << ",";
	    out << "(";
	    out << i->first;
	    out << "=";
	    out << i->second;
	    out << ")";
	}
	out << "]";
	break;
    case EV_SUB:
	out << "SUB";
	out << " guid=" << ev->origin;
	out << " subs=[";
	for (InterestSetIter i = ev->subs.begin(); 
	     i != ev->subs.end(); i++) {
	    if (i != ev->subs.begin()) out << ",";
	    out << **i;
	}
	out << "]";
	break;
    case EV_CREATE:
	out << "CREATE";
	out << " creator=" << ev->origin;
	out << " createe=" << ev->target;
	out << " attrs=[";
	for (AttributeMapIter i = ev->attributes.begin(); 
	     i != ev->attributes.end(); i++) {
	    if (i != ev->attributes.begin()) out << ",";
	    out << "(";
	    out << i->first;
	    out << "=";
	    out << i->second;
	    out << ")";
	}
	out << "]";
	break;
    case EV_DESTROY:
	out << "DESTROY";
	out << " guid=" << ev->origin;
	break;
    default:
	Debug::die("unknown event type: %d", ev->type);
    }
    out << ")";
    return out;
}
// vim: set sw=4 sts=4 ts=8 noet: 
// Local Variables:
// Mode: c++
// c-basic-offset: 4
// tab-width: 8
// indent-tabs-mode: t
// End:
