////////////////////////////////////////////////////////////////////////////////
// Mercury and Colyseus Software Distribution 
// 
// Copyright (C) 2004-2005 Ashwin Bharambe (ashu@cs.cmu.edu)
//               2004-2005 Jeffrey Pang    (jeffpang@cs.cmu.edu)
//                    2004 Mukesh Agrawal  (mukesh@cs.cmu.edu)
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2, or (at
// your option) any later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA
////////////////////////////////////////////////////////////////////////////////
/* -*- Mode:c++; c-basic-offset:4; tab-width:4; indent-tabs-mode:t -*- */

/**************************************************************************
  SystemEvent.h

begin           : Oct 16, 2003
version         : $Id: SystemEvent.cpp 2382 2005-11-03 22:54:59Z ashu $
copyright       : (C) 2003      Jeff Pang        ( jeffpang@cs.cmu.edu )
(C) 2003      Justin Weisz     (  jweisz@cs.cmu.edu  )

***************************************************************************/

#include "SystemEvent.h"
#include <framework2/GObject.h>

    SystemEvent::SystemEvent(gtime_t time, sev_t type) : 
	WEvent(time, WEvent::SYSTEM_EVENT), type(type), obj(NULL) {
  }

ostream& operator <<(ostream& out, SystemEvent *ev) {
    out << "(SystemEvent time=" << ev->time << " type=";
    switch(ev->type) {
    case EV_TIMER:
	out << "TIMER";
	out << " sid=" << ev->sid;
	out << " timer=";
	switch(ev->timer_type) {
	case TIMER_MIGRATE: out << "migrate"; break;
	case TIMER_INTEREST: out << "interest"; break;
	default: out << "unknown"; break;
	}
	break;
    case EV_MIGRATE:
	out << "MIGRATE";
	out << " from=" << ev->sid;
	out << " to=" << ev->targ;
	out << " obj=" << (ev->obj==NULL?GUID_NONE:ev->obj->guid);
	break;
    default:
	Debug::die("unknown event type: %d", ev->type);
    }
    out << ")";
    return out;
}
// vim: set sw=4 sts=4 ts=8 noet: 
// Local Variables:
// Mode: c++
// c-basic-offset: 4
// tab-width: 8
// indent-tabs-mode: t
// End:
