////////////////////////////////////////////////////////////////////////////////
// Mercury and Colyseus Software Distribution 
// 
// Copyright (C) 2004-2005 Ashwin Bharambe (ashu@cs.cmu.edu)
//               2004-2005 Jeffrey Pang    (jeffpang@cs.cmu.edu)
//                    2004 Mukesh Agrawal  (mukesh@cs.cmu.edu)
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2, or (at
// your option) any later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA
////////////////////////////////////////////////////////////////////////////////
/* -*- Mode:c++; c-basic-offset:4; tab-width:4; indent-tabs-mode:t -*- */

/**************************************************************************
  SimProtocolLayer.h

begin           : Nov 8, 2003
version         : $Id: SimProtocolLayer.h 2382 2005-11-03 22:54:59Z ashu $
copyright       : (C) 2003      Jeff Pang        ( jeffpang@cs.cmu.edu )
(C) 2003      Justin Weisz     (  jweisz@cs.cmu.edu  )

***************************************************************************/

#ifndef __SIM_PROTOCOL_LAYER_H__
#define __SIM_PROTOCOL_LAYER_H__

#include <framework2/common.h>
#include <framework2/GObject.h>
#include <framework2/GUpdate.h>
#include <framework2/GEvent.h>
#include <framework2/Server.h>
#include <framework2/ProtocolLayer.h>
#include "God.h"
#include "Logger.h"

    // how large each time bucket will be 
    // (aggregate all packets into bucket this size)
#define BUCKET_SIZE 100

    typedef struct {
	gtime_t time;
	uint32  size;
    } Measurement;

typedef list<Measurement> Window;
typedef Window::iterator WindowIter;

class WindowPair {
 public:
    Window inbound;
    Window outbound;
};

typedef map<SID, WindowPair *, less_SID> Windows;
typedef Windows::iterator WindowsIter;

typedef map<SID, int, less_SID> Clients;
typedef Clients::iterator ClientsIter;

/**
 * Dummy protocol layer for simulation
 */
class SimProtocolLayer : public ProtocolLayer {
 private:

    friend class God;

    void log_in(uint32 size);
    void log_out(uint32 size);
    void checkLightlyLoaded(Server *serv);
    void handleMigrate(SystemEvent *ev);

 protected:

    const gtime_t windowSize;
    Windows windows;

    Clients clients;

    LoadMap lightlyLoaded;

    /**
     * Global state
     */
    God *god;

    /**
     * Logger module
     */
    Logger *logger;

 public:

    SimProtocolLayer(God *god, Logger *logger, gtime_t bwidthWindowSize);
    virtual ~SimProtocolLayer();

    virtual void registerHandler(Server *s);
    virtual void clientConnect(GObject *client);
    virtual void clientDisconnect(GObject *client);
    virtual int  getNumClients();
    int  getNumClients(SID sid);
    virtual void publish(GEvent *e);
    virtual void subscribe(Interest *i);
    virtual void update(SID server, GUpdate *delta);
    virtual void migrate(GObject *o, SID server);
    virtual gtime_t getTime();
    virtual void registerInterrupt(gtime_t time, interrupt_t type);

    virtual bwidth_t inboundBwidth();
    virtual bwidth_t outboundBwidth();
    bwidth_t inboundBwidth(SID sid);
    bwidth_t outboundBwidth(SID sid);

    virtual void checkLightlyLoaded();
    virtual LoadMap *getLightlyLoaded();

    // warning -- must output exactly 1 line on this stream!
    virtual ostream& debugStream();

    void addServer(Server *s);

};

#endif
// vim: set sw=4 sts=4 ts=8 noet: 
// Local Variables:
// Mode: c++
// c-basic-offset: 4
// tab-width: 8
// indent-tabs-mode: t
// End:
