////////////////////////////////////////////////////////////////////////////////
// Mercury and Colyseus Software Distribution 
// 
// Copyright (C) 2004-2005 Ashwin Bharambe (ashu@cs.cmu.edu)
//               2004-2005 Jeffrey Pang    (jeffpang@cs.cmu.edu)
//                    2004 Mukesh Agrawal  (mukesh@cs.cmu.edu)
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2, or (at
// your option) any later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA
////////////////////////////////////////////////////////////////////////////////
/* -*- Mode:c++; c-basic-offset:4; tab-width:4; indent-tabs-mode:t -*- */

/**************************************************************************
  SimObject.h

begin           : Oct 16, 2003
version         : $Id: SimObject.h 2382 2005-11-03 22:54:59Z ashu $
copyright       : (C) 2003      Jeff Pang        ( jeffpang@cs.cmu.edu )
(C) 2003      Justin Weisz     (  jweisz@cs.cmu.edu  )

***************************************************************************/

#ifndef __SIM_OBJECT_H__
#define __SIM_OBJECT_H__

#include <framework2/common.h>
#include <framework2/GObject.h>
#include <framework2/TypeTable.h>

    class WorkloadApp;
class TraceEvent;
class GEvent;
class GUpdate;

#define SIM_OBJECT_TYPE 1
GObject *OCF_SimObject(Packet *pkt);
GObject *ECF_SimObject(GEvent *evt);

/**
 * Implementation of a game object for the WorkloadApp
 */
class SimObject : public GObject {
 private:

    friend GObject *OCF_SimObject(Packet *);
    friend GObject *ECF_SimObject(GEvent *);

    GEvent *nextEvent;
    GUpdate *nextUpdate;

    void setUpdate(TraceEvent *ev);
    void setEvent(TraceEvent *ev);

    void setObjectCosts(string *type);

 protected:

    friend class WorkloadApp;

    void setMod(TraceEvent *ev);
    virtual void fillEvent(GEvent *ev);
    virtual GUpdate *createUpdate();
    virtual void handleUpdate(GUpdate *delta);

 public:

    SimObject(GUID guid, Value init_vals[]);
    virtual ~SimObject();
    virtual bool isClient();
    virtual gtype_t typeCode();

    ////////// IMPLEMENTS SERIALIZABLE //////////

    SimObject(Packet *buffer);
};

#endif
// vim: set sw=4 sts=4 ts=8 noet: 
// Local Variables:
// Mode: c++
// c-basic-offset: 4
// tab-width: 8
// indent-tabs-mode: t
// End:
