////////////////////////////////////////////////////////////////////////////////
// Mercury and Colyseus Software Distribution 
// 
// Copyright (C) 2004-2005 Ashwin Bharambe (ashu@cs.cmu.edu)
//               2004-2005 Jeffrey Pang    (jeffpang@cs.cmu.edu)
//                    2004 Mukesh Agrawal  (mukesh@cs.cmu.edu)
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2, or (at
// your option) any later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA
////////////////////////////////////////////////////////////////////////////////
/* -*- Mode:c++; c-basic-offset:4; tab-width:4; indent-tabs-mode:t -*- */

/**************************************************************************
  SimObject.cpp

begin           : Oct 16, 2003
version         : $Id: SimObject.cpp 2382 2005-11-03 22:54:59Z ashu $
copyright       : (C) 2003      Jeff Pang        ( jeffpang@cs.cmu.edu )
(C) 2003      Justin Weisz     (  jweisz@cs.cmu.edu  )

***************************************************************************/

#include <framework2/GObject.h>
#include <framework2/GEvent.h>
#include <framework2/GUpdate.h>
#include "sim_shared.h"
#include "SimObject.h"
#include "WorkloadApp.h"
#include "TraceEvent.h"

    // TODO: this can probably be generated automatically some how
    GObject *OCF_SimObject(Packet *pkt) {
    return new SimObject(pkt);
  }

// TODO: This is *really* yucky. An application writer should NOT have
// to do this... maybe make this automatic? We have to decide what stuff
// goes into events: everything? a delta? how to reconstruct from a delta?
GObject *ECF_SimObject(GEvent *evt) {
    // for the simulator we put everything in a pub
    Value vals[NUM_ATTRS];
    // initial attributes
    for (int i=0; i<NUM_ATTRS; i++) {
	Value *valp = evt->GetAttribute(ATTRS[i]);
	if (valp != NULL) {
	    vals[i] = *valp;
	} else {
	    vals[i].m_Type = ATTR_INVALID;
	} 
    }

    SimObject *obj = new SimObject(evt->getGUID(), vals);

    //AttrKeyVec vec = evt->getKeys();
    //for (AttrKeyVecIter i = vec.begin(); i != vec.end(); i++) {
    //	Value *valp = evt->GetAttribute(*i);
    //	obj->attributes[*i] = *valp;
    //}

    obj->sid = evt->getSID();
    obj->setObjectCosts(obj->getAttribute(TYPE).m_Sval);

    return obj;
}

void SimObject::setMod(TraceEvent *ev) {
    ASSERT(ev->type == EV_MOD);
    ASSERT(ev->target == guid);

    if (getReplicaStatus() == PRIMARY) {
	setEvent(ev);
    } else {
	setUpdate(ev);
    }
}

void SimObject::setEvent(TraceEvent *ev) {
    ASSERT(nextEvent == NULL);

    /*
      nextEvent = new GEvent(this);
      // TODO: should this be the size of the object? we can't
      // completely delta encode objects...
      nextEvent->AddTuple(SIZE, Value( repDataSize(*(getAttribute(TYPE).m_Sval)) ));
      nextEvent->AddTuple(TYPE, getAttribute(TYPE));
      nextEvent->AddTuple(NODE, getAttribute(NODE));
    */
}

void SimObject::setUpdate(TraceEvent *ev) {
    ASSERT(nextUpdate == NULL);

    GEvent *pub = new GEvent(this);
    pub->AddTuple(SIZE, Value(ev->size));

    nextUpdate = new GUpdate(guid, pub);
}

void SimObject::fillEvent(GEvent *ev) {
    /*
      if (nextEvent != NULL) {
      GEvent *ret = nextEvent;
      nextEvent = NULL;
      return ret;
      } else {
      // "default" publication... uh, this is the same as the normal pub :P
      */
    // yes it is... wtf were we doing?
    ev->AddTuple(SIZE, Value( repDataSize(*(getAttribute(TYPE).m_Sval)) ));
    ev->AddTuple(TYPE, getAttribute(TYPE));
    ev->AddTuple(NODE, getAttribute(NODE));
    /*
      }
    */
}

GUpdate *SimObject::createUpdate() {
    ASSERT(nextUpdate != NULL);
    GUpdate *ret = nextUpdate;
    nextUpdate = NULL;
    return ret;
}

void SimObject::handleUpdate(GUpdate *delta) {
    for (EventIter i = delta->begin(); i != delta->end(); i++) {
	if (i->first == NODE) {
	    attributes[i->first] = i->second.GetValue();
	}
    }
}

SimObject::SimObject(GUID guid, Value init_vals[]) :
    GObject(guid, ATTRS, NUM_ATTRS, init_vals), 
    nextEvent(NULL), nextUpdate(NULL) {

    setObjectCosts(getAttribute(TYPE).m_Sval);
}

SimObject::~SimObject() {
    ASSERT(nextUpdate == NULL);
    ASSERT(nextEvent == NULL);
}

bool SimObject::isClient() {
    string *v = attributes[TYPE].m_Sval;
    ASSERT(v != NULL);
    return *v == PLAYER;
}

gtype_t SimObject::typeCode() {
    return SIM_OBJECT_TYPE;
}

SimObject::SimObject(Packet *buffer) : 
    GObject(buffer), nextEvent(NULL), nextUpdate(NULL) {

    setObjectCosts(getAttribute(TYPE).m_Sval);
}

// TODO: this should be from a config or something
void SimObject::setObjectCosts(string *type) {
    if ((*type) == PLAYER) {
	bcopy(&PLAYER_COSTS, &costs, sizeof(ObjectCosts));
    } else if ((*type) == MISSILE) {
	bcopy(&MISSILE_COSTS, &costs, sizeof(ObjectCosts));
    } else if ((*type) == ITEM) {
	bcopy(&ITEM_COSTS, &costs, sizeof(ObjectCosts));
    } else {
	Debug::die("unknown object type: %s", type->c_str());
    }
}
// vim: set sw=4 sts=4 ts=8 noet: 
// Local Variables:
// Mode: c++
// c-basic-offset: 4
// tab-width: 8
// indent-tabs-mode: t
// End:
