////////////////////////////////////////////////////////////////////////////////
// Mercury and Colyseus Software Distribution 
// 
// Copyright (C) 2004-2005 Ashwin Bharambe (ashu@cs.cmu.edu)
//               2004-2005 Jeffrey Pang    (jeffpang@cs.cmu.edu)
//                    2004 Mukesh Agrawal  (mukesh@cs.cmu.edu)
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2, or (at
// your option) any later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA
////////////////////////////////////////////////////////////////////////////////
/* -*- Mode:c++; c-basic-offset:4; tab-width:4; indent-tabs-mode:t -*- */

/**************************************************************************
  Logger.cpp

begin           : Nov 8, 2003
version         : $Id: Logger.cpp 2382 2005-11-03 22:54:59Z ashu $
copyright       : (C) 2003      Jeff Pang        ( jeffpang@cs.cmu.edu )
(C) 2003      Justin Weisz     (  jweisz@cs.cmu.edu  )

***************************************************************************/

#include "Logger.h"

    Logger::Logger(char *filename, God *god) : god(god) {
    out.open(filename, ios::out | ios::trunc );
    if (!out) {
	Debug::die("can't open %s", filename);
    }
  }


Logger::~Logger() {
    out.close();
}

void Logger::logUpdate(SID from, SID to, GUID target, uint32 sz) {
    out << god->getCurrTime() << " UPDATE " <<
	from << " " << to << " " << target << " " << sz << endl;
}

void Logger::logSub(SID from, uint32 sz) {
    out << god->getCurrTime() << " SUB_SEND " <<
	from << " " << sz << endl;
}

void Logger::logPubSend(SID from, GUID obj, uint32 sz) {
    out << god->getCurrTime() << " PUB_SEND " <<
	from << " " << obj << " " << sz << endl;
}

void Logger::logPubRecv(SID to, GUID obj, uint32 sz) {
    out << god->getCurrTime() << " PUB_RECV " <<
	to << " " << obj << " " << sz << endl;
}

void Logger::logMigration(SID from, SID to, GUID obj, uint32 sz) {
    out << god->getCurrTime() << " MIGRATE " <<
	from << " " << to << " " << obj << " " << sz << endl;
}

void Logger::logClientLoad(SID serv, bwidth_t load_in, bwidth_t load_out) {
    out << god->getCurrTime() << " CLIENT " << serv << " " <<
	load_in << " " << load_out << endl;
}

ostream& Logger::getDebugStream() {
    out << god->getCurrTime() << " DEBUG ";
    return out;
}
// vim: set sw=4 sts=4 ts=8 noet: 
// Local Variables:
// Mode: c++
// c-basic-offset: 4
// tab-width: 8
// indent-tabs-mode: t
// End:
