// file          : examples/Triangulation_2/voronoi.C
#include <CGAL/basic.h>
#include <fstream>

#include <CGAL/Cartesian.h>
#include <CGAL/Delaunay_triangulation_2.h>

typedef double coord_type;
typedef CGAL::Cartesian<coord_type>  Gt;
typedef CGAL::Delaunay_triangulation_2<Gt>  Triangulation;
typedef Triangulation::Edge_iterator  Edge_iterator;
typedef Triangulation::Vertex_circulator Vertex_circulator;

int main(int argc, char **argv)
{
    if (argc != 2) {
	std::cerr << "usage: voronoi <input_file>" << std::endl;
	exit(1);
    }

    std::ifstream in(argv[1]);
    if (!in) {
	std::cerr << "couldn't open " << argv[1] << std::endl;
	exit(1);
    }
    std::istream_iterator<Gt::Point_2> begin(in);
    std::istream_iterator<Gt::Point_2> end;
    Triangulation T;
    T.insert(begin, end);
    
    int ns = 0;
    //int nr = 0;  
    Edge_iterator eit =T.edges_begin();
    for ( ; eit !=T.edges_end(); ++eit) {
	CGAL::Object o = T.dual(eit);
	Gt::Segment_2 s;
	//Triangulation::Edge e = *eit;
	//Gt::Ray_2     r;
	if (CGAL::assign(s,o)) {
	    std::cout << s.source() << " " << s.target() << std::endl;
	    ++ns;
	}
    }
  
    Vertex_circulator vc = T.incident_vertices(T.infinite_vertex()), done(vc);
    if (vc != 0) {
	do { 
	    std::cout << vc->point() << std::endl;
	} while(++vc != done);
    }
    return 0;
}
 
