#!/usr/bin/perl

use strict;
use Getopt::Std;
use vars qw($opt_d $opt_r);

getopts ("d:r");

our $DIR = defined $opt_d ? $opt_d : "maps";
our $RECTMAPS = defined $opt_r;

my $STD_Q3_MAP_WIDTH = 2800;
my $STD_Q3_PLAYERS   = 16;

# stats for a 1 player map
our $BASE_SIZE = 700; # per player
our $BASE_BUILDINGS = 1;
our $BUILDINGS_MEAN = 650/4;
our $BUILDINGS_STD  = 650/8;
our $GOAL_PROB = 0.05;
our $RADIUS = 32;

our @sizes = ( 2, 3, 4, 6, 7, 8, 10, 12, 14, 15, 16, 18, 20, 23, 28, 32, 35, 40, 45, 50, 60, 70, 80, 90, 100 );

system("mkdir -p $DIR") && die "can't make $DIR";

foreach my $size (@sizes) {
    my $nplayers = $size*$size;
    my $realsize = $BASE_SIZE*$size;
    my $numbuildings = $BASE_BUILDINGS*$size*$size;
    
    my $cmd = "./mapgen ";
    if ($RECTMAPS) {
	my $y = $STD_Q3_MAP_WIDTH;
	my $x = ($nplayers * $STD_Q3_MAP_WIDTH) / $STD_Q3_PLAYERS;

	$cmd .= " -x $x -y $y ";
    }
    else {
	$cmd .= " -x $realsize -y $realsize ";
    }

    $cmd .= " -n $numbuildings -m $BUILDINGS_MEAN -t $BUILDINGS_STD -p $GOAL_PROB -r $RADIUS -o $DIR/$nplayers-players";
    system "$cmd";
}
