#!/usr/bin/perl

use strict;
use lib "$ENV{HOME}/Merc/run";
use Travertine;
use Getopt::Std;
use vars qw($opt_l $opt_s $opt_d $opt_n);

getopts("l:s:d:n:");

our $LOSSRATE = $opt_l || 0.01;
our $SENDINTERVAL = $opt_s || 100;
our $DELTASIZE = $opt_d || 100;
our $NOBJECTS = $opt_n || 20;

ParallelExec2(sub {
    my ($me, $to) = @_;
    psystem("xterm -hold -e \"./repconntest --loss_rate $LOSSRATE --send_interval $SENDINTERVAL --delta_size $DELTASIZE --nobjects $NOBJECTS $me $to | tee /tmp/$me.out\"");
} ,
	      ["localhost:10000", "localhost:10001"], 
	      ["localhost:10001", "localhost:10000"] );
