////////////////////////////////////////////////////////////////////////////////
// Mercury and Colyseus Software Distribution 
// 
// Copyright (C) 2004-2005 Ashwin Bharambe (ashu@cs.cmu.edu)
//               2004-2005 Jeffrey Pang    (jeffpang@cs.cmu.edu)
//                    2004 Mukesh Agrawal  (mukesh@cs.cmu.edu)
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2, or (at
// your option) any later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA
////////////////////////////////////////////////////////////////////////////////

/***************************************************************************

  TestObject.h

begin		   : April 5, 2004
copyright	   : (C) 2003 Jeffrey Pang   ( jeffpang@cs.cmu.edu )

***************************************************************************/

#ifndef __TEST_OBJECT__
#define __TEST_OBJECT__

#include <string>
#include <om/GObject.h>
#include "TestValue.h"

///////////////////////////////////////////////////////////////////////////////

typedef map<string, TestValue> AttributeMap;
typedef AttributeMap::iterator AttributeMapIter;

class test_ref_t : public GObjectRef {
 public:
    string attr;
    GUID guid;

    test_ref_t(string attr, GUID guid) : 
	attr(attr), guid(guid) {}
    virtual ~test_ref_t() {}

    GUID GetTarget() { return guid; }
};

typedef map<string,test_ref_t *> RefMap;
typedef RefMap::iterator RefMapIter;

///////////////////////////////////////////////////////////////////////////////

class TestAdaptor;

class TestObject : public GObject {
 private:
    friend ostream& operator<<(ostream& out, TestObject *obj);

    bool m_IsNew;
    bool m_Migrating;
    RefMap m_Refs;

    CostMetric m_FixedCost;
    CostMetric m_DeltaCost;

    OMInterest     m_Interest;

    void _FillEvent(OMEvent *ev);

 protected:
    AttributeMap m_Attributes;

 public:

    static TestAdaptor *m_TestAdaptor;

    TestObject(GUID id);
    TestObject(GObjectInfoIface *info, Packet *conn, 
	       const DeltaMask& mask, SIDMap *unresolved);
    virtual ~TestObject() {}

    void SetAttribute(string key, TestValue new_val);
    TestValue& GetAttribute(string key);
    void SetInterest(OMInterest& sub);
    OMInterest *GetInterest() { return &m_Interest; }

    ////////// Implements GObject //////////

    bool IsNew() { return m_IsNew; }
    void SetIsNew(bool val) { m_IsNew = val; }

    void FillEvents(EventList *reg,
		    EventList *unreg,
		    EventSet  *curr);

    uint32 InterestTime(OMEvent *ev, InterestMap *curr);
    uint32 InterestTime(GObject *obj, InterestMap *curr);

    uint32 FillInterest(OMInterest *in, OMInterest *old);

    const DeltaMask& GetInitDeltaMask();
    void PackUpdate(Packet *pkt, const DeltaMask& mask);
    void UnpackUpdate(Packet *pkt, const DeltaMask& mask, 
		      SIDMap *unresolved);

    void GetRefs(GObjectRefList *tofill);
    void ResolveRef(GObjectRef *ref, GObject *obj);

    ///////// Optional API /////////

    bool IsMigratable();
    uint32 BeginMigration(sid_t target);
    void CancelMigration(sid_t target);
    void CommitMigration(sid_t target);

    void SetFixedCost(CostMetric cost) { m_FixedCost = cost; }
    void SetDeltaCost(CostMetric cost) { m_DeltaCost = cost; }

    CostMetric GetFixedCost() { return m_FixedCost; }
    CostMetric GetDeltaCost() { return m_DeltaCost; }
};

ostream& operator<<(ostream& out, TestObject *obj);

#endif
// vim: set sw=4 sts=4 ts=8 noet: 
// Local Variables:
// Mode: c++
// c-basic-offset: 4
// tab-width: 8
// indent-tabs-mode: t
// End:
