////////////////////////////////////////////////////////////////////////////////
// Mercury and Colyseus Software Distribution 
// 
// Copyright (C) 2004-2005 Ashwin Bharambe (ashu@cs.cmu.edu)
//               2004-2005 Jeffrey Pang    (jeffpang@cs.cmu.edu)
//                    2004 Mukesh Agrawal  (mukesh@cs.cmu.edu)
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2, or (at
// your option) any later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA
////////////////////////////////////////////////////////////////////////////////

/***************************************************************************

  TestAdaptor.h

begin		   : April 5, 2004
copyright	   : (C) 2003 Jeffrey Pang   ( jeffpang@cs.cmu.edu )

***************************************************************************/

#ifndef __TEST_ADAPTOR__
#define __TEST_ADAPTOR__

#include <mercury/common.h>
#include <om/GameAdaptor.h>
#include <om/GUpdate.h>

#define MAX_ATTRS 32

struct TestAttribute {
    string key;
    bool isNamed;
};

typedef vector<TestAttribute> TestAttributes;
typedef set<string> NamedAttributes;

class TestObject;

class TestStore : public ObjectStore {
 protected:
    friend class TestAdaptor;
    map<GUID, GObject *, less_GUID> m_Store;
    map<GUID, GObject *, less_GUID>::iterator m_Curr;
 public:

    TestStore() {};
    virtual ~TestStore() {};

    void Begin();
    GObject *Next();
    GObject *Find(guid_t guid);
    void _ManagerAdd(GObject *obj);
    void _ManagerRemove(guid_t guid);

    void _ApplicationAdd(GObject *obj);
    void _ApplicationRemove(guid_t guid);
};

class TestAdaptor : public GameAdaptor {
 protected:
    TestStore m_Store;
    TestStore m_Pending;
    uint32    m_SendInterval;

    TestAttributes m_Attributes;
    NamedAttributes m_NamedAttributes;
 public:

    TestAdaptor() { m_SendInterval = 1000; }
    virtual ~TestAdaptor() {}

    void   SetSendInterval(uint32 interval) { m_SendInterval = interval; }
    uint32 GetSendInterval();
    ObjectStore *GetObjectStore();
    ObjectStore *GetPendingStore();
    GObject *Construct(GObjectInfoIface *info,
		       Packet *pkt, const DeltaMask& mask,
		       SIDMap *unresolved);
    void FillInterests(InterestList *reg,
		       InterestList *unreg,
		       GUIDMap *reg_assoc,
		       InterestMap *curr);
    void Destroy(GUID guid);

    // should only be called once
    void SetAttributes(TestAttributes& attrs) {
	m_Attributes = attrs;
	// for now TestApp only supports 1 attr per bit in the
	// bit mask...
	ASSERT(attrs.size() <= MAX_ATTRS);
	for (uint32 i=0; i<m_Attributes.size(); i++) {
	    if (m_Attributes[i].isNamed)
		m_NamedAttributes.insert(m_Attributes[i].key);
	}
    }
    TestAttributes *GetAttributes() { return &m_Attributes; }
    NamedAttributes *GetNamedAttributes() { return &m_NamedAttributes; }
    bool  IsNamedAttribute(string key) {
	return m_NamedAttributes.find(key) != m_NamedAttributes.end();
    }
};

extern TestAdaptor g_TestAdaptor;

#endif
// vim: set sw=4 sts=4 ts=8 noet: 
// Local Variables:
// Mode: c++
// c-basic-offset: 4
// tab-width: 8
// indent-tabs-mode: t
// End:
