////////////////////////////////////////////////////////////////////////////////
// Mercury and Colyseus Software Distribution 
// 
// Copyright (C) 2004-2005 Ashwin Bharambe (ashu@cs.cmu.edu)
//               2004-2005 Jeffrey Pang    (jeffpang@cs.cmu.edu)
//                    2004 Mukesh Agrawal  (mukesh@cs.cmu.edu)
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2, or (at
// your option) any later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA
////////////////////////////////////////////////////////////////////////////////

/***************************************************************************

  TestAdaptor.cpp

begin		   : April 5, 2004
copyright	   : (C) 2003 Jeffrey Pang   ( jeffpang@cs.cmu.edu )

***************************************************************************/

#include <om/Manager.h>
#include <om/test/TestAdaptor.h>
#include <om/test/TestObject.h>

TestAdaptor g_TestAdaptor;
Manager *g_Manager;

void TestStore::Begin() {
    m_Curr = m_Store.begin();
}

GObject *TestStore::Next() {
    if (m_Curr == m_Store.end()) {
	return NULL;
    } else {
	GObject *next = m_Curr->second;
	m_Curr++;
	return next;
    }
}

GObject *TestStore::Find(guid_t guid) {
    map<GUID, GObject *, less_GUID>::iterator p = m_Store.find(guid);
    if (p == m_Store.end()) {
	return NULL;
    } else {
	return p->second;
    }
}

void TestStore::_ManagerAdd(GObject *obj) {
    if (m_Store.find(obj->GetGUID()) != m_Store.end()) {
	// throw away the old copy
	delete m_Store[obj->GetGUID()];
    }

    m_Store[obj->GetGUID()] = obj;
}

void TestStore::_ManagerRemove(guid_t guid) {
    m_Store.erase(guid);
}

void TestStore::_ApplicationAdd(GObject *obj)
{
    _ManagerAdd(obj);
}

void TestStore::_ApplicationRemove(guid_t guid)
{
    _ManagerRemove(guid);
}

uint32 TestAdaptor::GetSendInterval() {
    return m_SendInterval;
}

ObjectStore *TestAdaptor::GetObjectStore() {
    return &m_Store;
}

ObjectStore *TestAdaptor::GetPendingStore() {
    return &m_Pending;
}

GObject *TestAdaptor::Construct(GObjectInfoIface *info,
				Packet *pkt, 
				const DeltaMask& mask,
				SIDMap *unresolved) {
    return new TestObject(info, pkt, mask, unresolved);
}

void TestAdaptor::FillInterests(InterestList *reg,
				InterestList *unreg,
				GUIDMap *reg_assoc,
				InterestMap *curr)
{
    TestObject *obj;
    ObjectStore *store = GetObjectStore();

    store->Begin();
    while ( (obj = (TestObject *)store->Next()) != NULL ) {
	if ( ! obj->IsReplica() ) {
	    GUID id = obj->GetInterest()->GetGUID();
	    InterestMapIter p = curr->find( id );
	    OMInterest *old = NULL;
	    if (p != curr->end())
		old = p->second;
	    OMInterest *in = g_Manager->CreateInterest();
	    uint32 ttl   = obj->FillInterest(in, old);

	    if ( ttl > 0 ) {				
		in->SetLifeTime( ttl );

		DB(1) << "obj " << obj->GetGUID()
		      << " filling sub: " << in
		      << endl;
		if (old) {
		    unreg->push_back(old);
		}
		reg->push_back(in);
		reg_assoc->insert(pair<GUID,GUID>(obj->GetGUID(), 
						  in->GetGUID()));
	    } else {
		g_Manager->FreeInterest(in);
	    }
	}
    }
}

void TestAdaptor::Destroy(GUID guid) {
    GObject *obj = GetObjectStore()->Find(guid);
    if (obj) {
	// XXX Might have to fix stale pointers!
	//
	// Can't use the ApplicationRemove callback here because
	// this Manager may be holding its lock. And Destroy is only
	// used on replicas, so there is no need for the callback.
	((TestStore *)GetObjectStore())->_ApplicationRemove(guid);
	delete obj;
    }
    obj = GetPendingStore()->Find(guid);
    if (obj) {
	((TestStore *)GetPendingStore())->_ApplicationRemove(guid);
	delete obj;
    }
}
// vim: set sw=4 sts=4 ts=8 noet: 
// Local Variables:
// Mode: c++
// c-basic-offset: 4
// tab-width: 8
// indent-tabs-mode: t
// End:
