#!/usr/bin/perl
#
# Simple regression test.
#
# (1) Test primary deletion.
# (2) Test forwarding pointers.
# (3) Test interest graph.
#
# XXX TODO: deletion of an object while it is begin resolved remotely

use strict;
require "TestLib.pl";

my $NUM_NODES = 5;
my $RANGE = 100;

start_bootstrap( "x" => [0, $RANGE] );

system "rm -f /tmp/*.log";

my %node = start_nodes($NUM_NODES, 
		       { "REPLICA_MAINTAIN_TTL" => 15000,
			 "INTEREST_LINK_TTL" => 15000,
			 "REPLICA_INTEREST_TTL" => 15000 },
		       "-l", 15000, "-v", 0,
		       "-f", "-D", "Manager,TestObject", "--pubtriggers",
		       #"--measurement", "--log-dir /tmp",
		       "--log-flush-interval", 10,
		       "-N", "x", "-A", "name,nickname,ptr,self");

my (@guid, %store, $primary, $replica, $temp);

sub dump_store($) {
    my %store   = store(shift @_);
    foreach my $k (keys %store) {
	print "$k => " . obj_to_str( $store{$k} ) . "\n";
    }
}

$guid[0] = add($node{1});
set($node{1}, $guid[0], "name", "s:Bobby");
set($node{1}, $guid[0], "x", "f:10");

$guid[1] = add($node{3});
setin($node{3}, $guid[1], ["x", ">", "f:0"], ["x", "<", "f:20"]);

info("##### TEST 1: Primary Deletion");

# need up to NUM_NODES cycles for Merc to fwd message around ring
merc_idle_all(\%node, $NUM_NODES);
# and a couple more for the registration and update delta
idle_all(\%node, 3);

$primary = show($node{1}, $guid[0]);
info("original: " .  obj_to_str( $primary ) );

%store   = store($node{3});
$replica = $store{$guid[0]};
#$replica = show($node{3}, $guid[0]);
info("replica: " .  obj_to_str( $replica ) );

remove($node{1}, $guid[0]);

merc_idle_all(\%node, $NUM_NODES);
idle_all(\%node, 3);

%store = store($node{3});
if (defined $store{$guid[0]}) {
    error("node 3 still contains replica of $guid[0]: " .
	  obj_to_str($store{$guid[0]}));
    fail();
}

info("##### TEST 2: Forwarding Pointers");

$guid[0] = add($node{1});
set($node{1}, $guid[0], "name", "s:Bart");
set($node{1}, $guid[0], "x", "f:10");

idle_all(\%node, 3);
merc_idle_all(\%node, $NUM_NODES);
idle_all(\%node, 3);

$primary = show($node{1}, $guid[0]);
info("original: " .  obj_to_str( $primary ) );

%store   = store($node{3});
$replica = $store{$guid[0]};
info("replica: " .  obj_to_str( $replica ) );

#info("node 1 connections:\n" . connections($node{1}));

migrate($node{1}, $guid[0], $node{2}->{sid});

# keep node 3 out of the loop so it's info goes stale
my $node3 = $node{3};
delete $node{3};

idle_all(\%node, 8);
#merc_idle_all(\%node, $NUM_NODES);

#info("node 2 connections:\n" . connections($node{2}));

$primary = show($node{2}, $guid[0]);
info("new_primary: " .  obj_to_str( $primary ) );

%store   = store($node3);
$replica = $store{$guid[0]};
info("old_replica: " .  obj_to_str( $replica ) );

if ( obj_eq($primary, $replica) ) {
    error("how the hell did node 3 get an up to date copy?");
    fail();
}

set($node3, $guid[0], "name", "s:Lisa");

Send($node3, 1);
idle_all(\%node, 4);

#info("node 2 connections:\n" . connections($node{2}));

%store   = store($node3);
$replica = $store{$guid[0]};
info("mod_replica: " .  obj_to_str( $replica ) );

$primary = show($node{2}, $guid[0]);
info("new_primary: " .  obj_to_str( $primary ) );

if ( $primary->{attrs}->{name}->[1] ne "Lisa" ) {
    error("node 2 never updated!");
    fail();
}

# put node3 back in with the rest
$node{3} = $node3;

merc_idle_all(\%node, $NUM_NODES);
idle_all(\%node, 3);

#dump_store($node{3});
%store = store($node{3});
$replica = $store{$guid[0]};
info("new_replica: " .  obj_to_str( $replica ) );

if ( !obj_eq($primary, $replica) ) {
    error("node 3 still has old replica!");
    fail();
}

remove($node{2}, $guid[0]);
remove($node{3}, $guid[0]);

idle_all(\%node, 3);

info("##### TEST 3: Interest Graph");

## Set up GUID array
my %guid;
for (my $i=1; $i<=$NUM_NODES; $i++) {
    $guid{$i} = [];
}

my $OBJS_PER_NODE = 5;
my $AOE = $RANGE/$OBJS_PER_NODE; #2*$RANGE/$OBJS_PER_NODE;

## Add Objects to each node
#for (my $i=1; $i<=$NUM_NODES; $i++) {
#    for (my $j = 0; $j<$OBJS_PER_NODE; $j++) {
#	$guid{$i}->[$j] = add($node{$i});
#    }
#}

## Set up GUID array
my %guid;
my %info;
for (my $i=1; $i<=$NUM_NODES; $i++) {
    $guid{$i} = [];
    $info{$i} = [];
}

## Add Objects to each node
for (my $i=1; $i<=$NUM_NODES; $i++) {
    for (my $j = 0; $j<$OBJS_PER_NODE; $j++) {
	$guid{$i}->[$j] = add($node{$i});

	$info{$i}->[$j] = {};
	
	$info{$i}->[$j]->{x} = int(rand($RANGE));
	
	$info{$i}->[$j]->{minx} = 
	    max(0, $info{$i}->[$j]->{x} - $AOE/2);
	$info{$i}->[$j]->{maxx} = 
	    min($RANGE, $info{$i}->[$j]->{x} + $AOE/2);

	set($node{$i}, $guid{$i}->[$j], "x", "f:" . $info{$i}->[$j]->{x});
	setin($node{$i}, $guid{$i}->[$j], 
	      ["x", ">=", "f:" . $info{$i}->[$j]->{minx}], 
	      ["x", "<=", "f:" . $info{$i}->[$j]->{maxx}]);
    }
}

idle_all(\%node, 1);
merc_idle_all(\%node, 10*$NUM_NODES);
idle_all(\%node, 1);
merc_idle_all(\%node, 10*$NUM_NODES);
idle_all(\%node, 2);

my @graph = graph($node{1});
my %gbs = graph_by_src(@graph); 
info("interst graph at node 1:\n" . graph_to_str(@graph));

my $failed = undef;

for (my $k = 0; $k<$OBJS_PER_NODE; $k++) {
    my $guid = $guid{1}->[$k];
    my $info = $info{1}->[$k];
    my $targets = $gbs{$guid};

    for (my $i=1; $i<=$NUM_NODES; $i++) {
	for (my $j = 0; $j<$OBJS_PER_NODE; $j++) {
	    next if $i == 1 && $j == $k;
	    
	    if ($info{$i}->[$j]->{x} >= $info->{minx} &&
		$info{$i}->[$j]->{x} <= $info->{maxx}) {

		if (! exists $targets->{$guid{$i}->[$j]}) {
		    error("$guid not interested in " . $guid{$i}->[$j] .
			  " but should be: x=" . $info{$i}->[$j]->{x} .
			  " range=[" . $info->{minx} . "," . 
			  $info->{maxx} . "]");
		    $failed = 1;
		}

	    } else {

		if (exists $targets->{$guid{$i}->[$j]}) {
		    error("$guid interested in " . $guid{$i}->[$j] .
			  " but should not be: x=" . $info{$i}->[$j]->{x} .
			  " range=[" . $info->{minx} . "," . 
			  $info->{maxx} . "]");
		    $failed = 1;
		}

	    }
	}
    }
}

if ($failed) {
    fail();
}

stop_all();
info("SUCCESS");
