#!/usr/bin/perl
#
# Test Displaying the Interest Graph
#

use strict;
require "TestLib.pl";

my $NUM_NODES = 5;
my $OBJS_PER_NODE = 2;
my $RANGE = 100;
my $AOE = 200;

start_bootstrap( "x" => ["float", 0, $RANGE], "y" => ["float", 0, $RANGE] );

my %node = start_nodes($NUM_NODES, 
		       { "REPLICA_MAINTAIN_TTL" => 10000,
			 "INTEREST_LINK_TTL" => 10000,
			 "REPLICA_INTEREST_TTL" => 10000 },
		       "-l", 5000, "-v", 0, "-D Manager,Test", "-P", "-f");

sub dump_store($) {
    my %store   = store(shift @_);
    foreach my $k (keys %store) {
	print "$k => " . obj_to_str( $store{$k} ) . "\n";
    }
}

## Set up GUID array
my %guid;
for (my $i=1; $i<=$NUM_NODES; $i++) {
    $guid{$i} = [];
}

## Add Objects to each node
for (my $i=1; $i<=$NUM_NODES; $i++) {
    for (my $j = 0; $j<$OBJS_PER_NODE; $j++) {
	$guid{$i}->[$j] = add($node{$i});
	
	my $x = rand($RANGE);
	my $y = rand($RANGE);
	
	my $minx = max(0, $x - $AOE/2);
	my $maxx = min($RANGE, $x + $AOE/2);
	my $miny = max(0, $y - $AOE/2);
	my $maxy = min($RANGE, $y + $AOE/2);

	set($node{$i}, $guid{$i}->[$j], "x", "f:$x");
	set($node{$i}, $guid{$i}->[$j], "y", "f:$y");
	setin($node{$i}, $guid{$i}->[$j], 
	      ["x", ">=", "f:$minx"], 
	      ["x", "<=", "f:$maxx"],
	      ["y", ">=", "f:$miny"], 
	      ["y", "<=", "f:$maxy"]);
    }
}

sleep(5);

for (my $i=1; $i<=$NUM_NODES; $i++) {
    for (my $j = 0; $j<$OBJS_PER_NODE; $j++) {
	$guid{$i}->[$j];

	my $target = int(rand($NUM_NODES))+1;
	if ($target == $i) {
	    $target = (($i+1) % $NUM_NODES) + 1;
	}
	
	migrate($node{$i}, $guid{$i}->[$j], $node{$target}->{sid});
    }
}

sleep(20);

dump_store($node{1});
dump_graph($node{1});

if (!success()) {
    fail();
}

stop_all();
info("SUCCESS");
