#!/usr/bin/perl

BEGIN {
    $ENV{TRAVERTINE_SSHVERSION} = "1,2";
    $ENV{TRAVERTINE_PRINTCMDS} = 1;
}
use strict;
use Net::hostent;
use Socket;
use IO::File;
use Getopt::Std;
use Travertine;
use vars qw($opt_v $opt_k $opt_T $opt_r $opt_p $opt_x);

getopts ("v:T:r:p:xk");

our $INVOKE_XTERM = defined $opt_x;
our $KILL         = defined $opt_k;
our $RUN_AS_BG = 1;
our $MAXPARALLEL = 5;
our $MODE = "";
our $LOG_DIR = "/home/Logs";
our $SAVEDIR = "ashu\@iris-d-10.cmcl.cs.cmu.edu:/misc/ashu/rnet-test";
our $VIRTUAL_SERVERS = defined $opt_v ? $opt_v : 1;
our $TIMELIMIT = defined $opt_T ? $opt_T : 60;    # seconds
our $APP_DIR = "Merc/build";
our $APP_EXE = "rnet-test";

my $realnet_slice = defined $opt_r ? $opt_r : 10000;
my $procmsg_slice = defined $opt_p ? $opt_p : $realnet_slice;

our $TOPDIR = "/proj/DNA/ashwin/Merc/build";
our $PROGRAM = $APP_EXE;
our $LIBRARY_PATH = ".:..";

# app args: --net-slice, --proc-slice, --myaddr, --server 

our $common_args = " --net-slice $realnet_slice --proc-slice $procmsg_slice --timelimit $TIMELIMIT";

our @MERC_PORTS   = (20000, 20001, 20002, 20003, 20004, 20005, 20006, 20007,
		     20008, 20009, 20010, 20011, 20012, 20013, 20014, 20015,
		     20016, 20017, 20018, 20019, 20020, 20021, 20022, 20023,
		     20024, 20025, 20026, 20027, 20028, 20029, 20030, 20031,
		     20032, 20033, 20034, 20035, 20036, 20037, 20038, 20039,);

tinfo "* initializing...";

our @logins = 
    map { 
	if ($_ !~ /\@/) { 
	    $_ = "$ENV{USER}\@$_"; 
	}
	if ($_ !~ /:/) {
	    my ($user, $host) = split(/@/, $_);
	    $_ = "$user\@$host:$host";
	}
	$_;
    } @ARGV;

# create ssh tunnels
our @ssh = ParallelExec2(sub {
    my $login = shift;
    my ($user, $host, $iface) = SplitLogin($login);
    my $ssh = Travertine::SSHTunnel->new($user, $host);
    tdie "can't open connection to $login" if !$ssh;
    return $ssh;
}, @logins);

our @servers;
for (my $i=0; $i<@logins; $i++) {
    $servers[$i] = [ $logins[$i], $ssh[$i], $VIRTUAL_SERVERS ];
}

if ($KILL) { 
    tinfo "** Cleaning processes; NOT cleaning the logs";
    ParallelExec3($MAXPARALLEL, \&StopServer, @ssh);
    exit (0);
}

tinfo "** starting servers ... ";
my @srefs = ParallelExec3($MAXPARALLEL, sub {
    my $server = shift;
    my $index  = 0;

    my @refs = ();

    while ($server->[2]-- > 0) {
    my $sserver = StartProgram($server->[0], $server->[1],
	$MERC_PORTS[$index], $index, 
	$common_args);
    tdie "couldn't start slave $server->[0] \#$index" if !$sserver;
    push @refs, [ $sserver, ToHost($server->[0]) . ":$index" ];

    $index++;
    }

    return \@refs;
}, map { $_ = [ $_ ]; } @servers);

tinfo " *** sleeping for $TIMELIMIT seconds ";
sleep ($TIMELIMIT);
ParallelExec3($MAXPARALLEL, \&StopServer, @ssh);

tinfo " * collecting logs";
my ($login, $host, $dir) = ($SAVEDIR =~ /^(\w+)\@([^:]+):(.*)$/);
if (!$login || !$host || !$dir) {
	tdie "invalid savedir: $SAVEDIR";
}
rsystem($login, $host, sub {
	my $dir = shift;
	psystem ("mkdir -p $dir");
	psystem ("rm -f $dir/*");
	}, $dir);
my $MAX_PARALLEL_RSYNCS = 10;

for (my $i=0; $i<@logins; $i += $MAX_PARALLEL_RSYNCS) {
    my $begin = $i;
    my $end   = $i+$MAX_PARALLEL_RSYNCS-1 > $#logins ? $#logins : $i+$MAX_PARALLEL_RSYNCS-1;

    ParallelExec2(sub {
	my $pref = shift;
	$pref =~ s/:.*$//;
	my ($user, $host) = split(/@/, $pref);
	
	rsystem($user, $host, sub {
	    my ($pref, $logdir, $SAVEDIR) = @_;
	    my $stat = psystem("rsync -v -e ssh -azb $logdir/* $SAVEDIR 1>&2");
	    if ($stat) {
		twarn "rsync of $pref:$logdir failed! not deleting logs!";
	    } else {
		# now delete them
		psystem("rm -f $logdir/*");
	    }
	}, $pref, $LOG_DIR, $SAVEDIR);

    }, @logins[$begin..$end]);
}

exit (0);

sub StartProgram
{
    my ($login, $ssh, $mercPort, $vindex, $args) = @_;
    my ($user, $host, $iface) = SplitLogin($login);

    my $seed = rand(42000);
    
    $args .= " --myaddr $iface:$mercPort";

    tinfo "* Starting $APP_EXE on: $iface:$mercPort";
    my @os; 
    foreach my $l (@logins) {
	my ($u, $h) = SplitLogin($l);
	foreach my $v (0 .. $VIRTUAL_SERVERS - 1) {
	    if ($l ne $login || $vindex != $v) {
		push @os, "$h:$MERC_PORTS[$v]";
	    }
	}
    }
    $args .= " --servers " . join(",", @os);
    return Run($ssh, \&RunProgram,
	       [$TOPDIR, $LIBRARY_PATH, "./$PROGRAM", $args, $MODE, 
		$LOG_DIR, $iface, $mercPort, $vindex, 0],
	       "$LOG_DIR/OutputLog.$iface:".($mercPort+5000).".out",
	       "$host:$mercPort");
}

# dont clean the logs, please!
sub StopServer
{
    my ($ssh) = shift @_;

    ExecRemoteFunc($ssh, sub {
	my $exe     = shift;
	my $runwithsudo = shift;

	my $killall = "killall";
	$killall = "sudo killall" if ($runwithsudo);
	
#	psystem("killall screen       >/dev/null 2>&1");
	psystem("$killall -1 bootstrap >/dev/null 2>&1");
	psystem("$killall -1 $exe      >/dev/null 2>&1");
	psystem("$killall -1 gdb       >/dev/null 2>&1");
	psystem("$killall -1 valgrind  >/dev/null 2>&1");

	sleep 1;
	psystem("$killall -9 bootstrap >/dev/null 2>&1");
	psystem("$killall -9 $exe      >/dev/null 2>&1");
	psystem("$killall -9 gdb       >/dev/null 2>&1");
	psystem("$killall -9 valgrind  >/dev/null 2>&1");
    }, [$PROGRAM, 0], -print => 1, -timeout => 100 );
}

sub RunProgram
{
    my ($topdir, $libpath, $prog, $args, $mode, $log_dir, 
	$if, $port, $vindex, $runwithsudo) = @_;

    chdir($topdir);
    $ENV{LD_LIBRARY_PATH} .= "$ENV{HOME}/lib:$ENV{HOME}/local/lib";
    $ENV{LD_LIBRARY_PATH} .= ":$libpath";

    my $cmd;
    if ($mode eq 'gdb') {
	my $temp = "/tmp/RunLocalTest.master.$$";
	open(T, ">$temp") || die $!;
	print T "handle SIGUSR2 nostop\n";
	print T "exec-file $prog\n";
	print T "r $args\n";
	close(T);
	$cmd = "gdb -x $temp $prog";
    } elsif ($mode eq 'valgrind') {
#	$cmd = "valgrind --tool=memcheck --db-attach=yes --suppressions=realnet.supp --gen-suppressions=yes --num-callers=5 $prog $args";
	$cmd = "valgrind --tool=memcheck --num-callers=6 $prog $args";
    } elsif ($mode eq 'valgrindmem') {
	$cmd = "valgrind --tool=addrcheck --leak-check=yes --show-reachable=yes $prog $args";
    } elsif ($mode eq 'pprof' || $mode eq 'pprof1' && $vindex == 0) {
	$cmd = "CPUPROFILE=$log_dir/Profile.$if:$port.out $prog $args";
    } elsif ($mode eq 'heapcheck' || $mode eq 'heapcheck1' && $vindex == 0) {
	$cmd = "HEAPCHECK=normal $prog $args";
    } elsif ($mode eq 'heapprof' || $mode eq 'heapprof1' && $vindex == 0) {
	$cmd = "HEAPPROFILE=/tmp/HeapProfile.$if:$port $prog $args";
    } else {
	$cmd = "$prog $args";
    }

    #psystem("netstat -u -s > $log_dir/Netstat.$if:$port.out");
    if ($runwithsudo) {
	psystem("sudo sh -c \"LD_LIBRARY_PATH=$libpath $cmd\"");
    }
    else {
	psystem ($cmd);
    }

    if ($? == -1) {
	twarn "failed to execute: $!";
    }
    elsif ($? & 127) {
	twarn sprintf "child died with signal %d, %s coredump",
	($? & 127),  ($? & 128) ? "with ":  " without ";
    }
    else {
	tinfo sprintf "child exited with value %d", $? >> 8;
    }
    #psystem("netstat -u -s >> $log_dir/Netstat.$if:$port.out");
}
sub Run
{
    my ($ssh, $func, $args, $log, $title) = @_;

    my %opts = ( -daemon => 1, 
		 -log => $log,
		 -title => $title );
    if ($RUN_AS_BG) {
	%opts = ( -background => 1,
		  -log => $log );
    }

    my $ref = ExecRemoteFunc($ssh, $func, $args, %opts);
    if (!$ref) {
	return undef;
    }

    if ($INVOKE_XTERM) {
	if ($RUN_AS_BG) {
	    twarn "can't attach to a bg func";
	} else {
	    $ref->attachToXterm();
	}
    }

    return $ref;
}


sub ResolveIP($)
{
    my $host = shift;

    if ($host !~ /\d+\.\d+\.\d+\.\d+/) {
	my $hent = gethost($host);
	die "bad hostname: $host -- $?" if
	    !defined $hent || @{$hent->addr_list} < 1;
	$host = inet_ntoa($hent->addr_list->[0]);
    }

    return $host;
}

sub SplitLogin($)
{
    my $login = shift;
    
    my ($user, $host, $iface) = ($login =~ /^([^\@]+)\@([^:]+):([^:]+)$/);
    die "bad login: $login" if !$user || !$host || !$iface;

    #$host  = ResolveIP($host);
    #$iface = ResolveIP($iface);

    return ($user, $host, $iface);
}

sub ToHost($)
{
    my ($user, $host, $iface) = SplitLogin(shift);
    return $iface;
}

