#!/usr/bin/perl

use strict;
use lib "./emulab";
use Travertine;
use EmulabConf;
use Getopt::Std;
use vars qw($opt_e $opt_l $opt_a);
require "./emulab/common.pl";

BEGIN {
    $ENV{TRAVERTINE_SSHVERSION} = "1,2";
    $ENV{TRAVERTINE_PRINTCMDS} = 0;
}

getopts ("e:la");
our $EMULAB = "emulab.net";
if (defined $opt_e) { 
    if ($opt_e =~ /schooner/) { $EMULAB = "schooner.wail.wisc.edu"; }
    elsif ($opt_e =~ /utah/) { $EMULAB = "emulab.net"; }
}

our $LOCALINST = defined $opt_l; #  should we install it on all hosts?;
our $ALLINST = defined $opt_a;

my $app_conf = shift @ARGV;
my $exp = shift @ARGV;
if (!$exp or !$app_conf) {
    print STDERR "usage: emulab/EmulabInstall.pl [-e utah,schooner] [-la] <app_conf.pl> <experiment_name>\n";
    exit 1;
}

our %NODE_MAP = GetExperimentNodeMapping ($EMULAB, $exp);

my $other_args = join " " , @ARGV;

# users.emulab.net doesn't work anymore... perl 5.005_3 is too old .. ;
if ($LOCALINST) { 
    my $cmd = "./BTInstall.pl $app_conf -l $LOCAL_TOPDIR -t $TOPDIR $other_args ";
    foreach my $k (keys %NODE_MAP) { 
	$cmd .= " $USERNAME\@$NODE_MAP{$k}.$EMULAB";
    }
    psystem ($cmd);
}
elsif ($ALLINST) {
    AllInstall();

# naive rsync to all impl here:    
#    psystem("./Install.pl $app_conf -l $LOCAL_TOPDIR -t $TOPDIR $other_args " .
#	    join(" ", map { "$USERNAME\@$_.$EMULAB" } values %NODE_MAP));
}
else {
# rsync to one dude
    psystem("./Install.pl $app_conf -l $LOCAL_TOPDIR -t $TOPDIR $other_args " .
	    "$USERNAME\@$NODE_MAP{node0}.$EMULAB");
}

###############################################################################

sub RecInstall
{
    our $PARALLEL_TODO = 2;

    my ($src, @todo) = @_;

    my @dest;
    my @rest;

    for (my $i=0; $i<$PARALLEL_TODO; $i++) {
	push @dest, shift @todo if @todo > 0;  
    }
    my $nrec = scalar @dest + 1;

    for (my $i=0; $i<@todo; $i++) {
	for (my $r = 0; $r < $nrec; $r++) {
	    if ($i % $nrec == $r) {
		$rest[$r] = [] if !$rest[$r];
		push @{$rest[$r]}, $todo[$i];
		last;
	    }
	}
    }

    tinfo "installing $src => (@dest)";
    # have him fanout to the @dest
    my $ret = Travertine::rsystem2($USERNAME, $src, sub {
	my ($topdir, $app_conf, $rest) = @_;

	chdir("$topdir/Merc/run") || twarn "can't chdir $topdir/Merc/run";
	psystem("tar xzf lib-*.tar.gz");
	$ENV{PERL5LIB} .= ":lib";

	if ( psystem("./Install.pl $app_conf -Z -r -t '$topdir' -l '$topdir' $rest") ) {
	    twarn "failed to install (is something missing from the install list?)";
	    return -1;
	}

	return 0;
    }, $TOPDIR, $app_conf, join(" ", @dest));

    if ($ret) {
	twarn "failed $src => (@dest)";
    }

    # recurse on rest
    my @srcs = ($src, @dest); 
    my @args;
    for (my $i=0; $i<@rest; $i++) {
	push @args, [$srcs[$i], @{$rest[$i]}];
    }

    ParallelExec2( \&RecInstall, @args ) if @args > 0;
    return;
}

sub AllInstall
{
    my $node0 = "$NODE_MAP{node0}.$EMULAB";
    delete $NODE_MAP{node0};
    my @rest = map { "$_.$EMULAB" } values %NODE_MAP;

    # rsync to one guy
    psystem("./Install.pl $app_conf -r -l $LOCAL_TOPDIR -t $TOPDIR " .
	    "$other_args $node0");

    # recursively install from this guy to the rest
    RecInstall($node0, @rest);
}
