#
# Run.pl configuration for Testgame
#

use strict;
use Travertine;
use Options;
use POSIX qw(ceil);
use vars qw($opt_z $opt_H $opt_b $opt_w $opt_m $opt_f $opt_i $opt_e $opt_I
	    $opt_Q $opt_D $PUB_INTERVAL $SUB_PREDICTION $MAXDISLAT);

# XXX HACK -- this must be in synch with RunV2.pl
our @MERC_PORTS   = (20000, 20001, 20002, 20003, 20004, 20005, 20006, 20007,
		     20008, 20009, 20010, 20011, 20012, 20013, 20014, 20015,
		     20016, 20017, 20018, 20019, 20020, 20021, 20022, 20023,
		     20024, 20025, 20026, 20027, 20028, 20029, 20030, 20031,
		     20032, 20033, 20034, 20035, 20036, 20037, 20038, 20039,);

###############################################################################
# The files to copy over to the remote host (relative to TOPDIR)
# (may be globs of files, but not of nested directories: ../*/*.. doesn't work)
# Do NOT include trailing slashes
#
our @APP_INST_DIST = (
      "Merc/build/bootstrap",
      "Merc/build/mercapp",
      "Merc/build/testgame",
      "Merc/build/chkjoin2",
      #"Merc/build/rnet-test",
      "Merc/build/params.conf",
      "Merc/build/*.cfg",
      "Merc/apps/mapgen/rect_maps/*",
      "Merc/apps/mapgen/maps/*",
      "Merc/*.so",
      "Merc/topologies/*.lat",
      "Merc/topologies/*.waspnet",
      "Merc/util/time-test/client",
      "Merc/util/time-test/server",
      "Merc/scripts/Topology2Waspnet.pl",
	);

# Function to execute on remote host before sync
#
our $APP_INST_PRE = sub {
    my $topdir = shift;
    my $username = shift;
    
    psystem("sudo mkdir -p $topdir");
    psystem("sudo chown $username $topdir");
};

# Function to execute on the remote host after sync
#
our $APP_INST_POST = sub {
    my $topdir = shift;

    my %links = ( 
    "Merc/build/rect_maps" => "Merc/apps/mapgen/rect_maps", 
    "Merc/build/maps" => "Merc/apps/mapgen/maps"
    );

    foreach my $from (keys %links) {
        psystem "rm -f $topdir/$from";
	psystem "ln -sf $topdir/$links{$from} $topdir/$from";
    }

    # chmod to correct permissions
    psystem("chmod -R g+rw $topdir/Merc >/dev/null 2>&1");
    
    # for stupid bittorrent which does not keep the permissions :(
    # or perhaps for stupid me who cant figure out how to make it 
    # preserve them. - Ashwin [08/21/2005]
    
    foreach my $prog ("bootstrap", "chkjoin2", "testgame") {
        psystem("chmod +x $topdir/Merc/build/$prog");
    }
};
# directory containing $APP_EXE in relation to $TOPDIR
# our $APP_DIR = "Merc/apps/testgame";
our $APP_DIR = "Merc/build";

# application executable name in $TOPDIR/$APP_DIR
our $APP_EXE = "testgame";

# library path (to libcolyseus) rlt to $TOPDIR/$APP_DIR
our $APP_LIBPATH = ".:..";

# path to bootstrap exe rlt to $TOPDIR/$APP_DIR
our $APP_BOOTSTRAP = "../build/bootstrap";

# path to artificial topologies (i.e. ../Merc/topologies)
our $APP_TOPODIR = "../topologies";

# default application mercury schema (may be changed)
our $APP_SCHEMA = "schema_test_onehub.cfg";

our $APP_TOPO2WASPNET = "../scripts/Topology2Waspnet.pl";

###############################################################################

our $MERC_LOADBAL = "";
# application script parameters (passed to perl script)
our @APP_OPT_TABLE = 
(
 Options::String("H", "bpatterns", "benchmark patterns", \$opt_H, undef),
 Options::String("z", "vis-ip", "visualizer IP addr", \$opt_z, undef),
 Options::String("b", "nbots", "number of bots to start", \$opt_b, undef),
 Options::String("m", "mapdir", "[dir] map directory (wrt APP_DIR)", \$opt_m, "../apps/mapgen/maps/16-players"),
 Options::String("i", "intsize", "rea of interest size (size^2 = area)", \$opt_i, undef),
 Options::String("f", "framelimit", "frame limit", \$opt_f, undef),
 Options::String("e", "timelimit", "time limit in msec", \$opt_e, undef),
 Options::String("D", "ndhtkeys", "number of pub/sub DHT region keys", \$opt_D, undef),
 Options::String("/", "pubinterval", "pub interval (msec)", \$PUB_INTERVAL, "1000"),
 Options::String("/", "subpred", "sub prediction for players (msec)", \$SUB_PREDICTION, "5000"),
 Options::String("/", "maxdislat", "max discovery lat for pred fudge (msec)", \$MAXDISLAT,"300"),
 Options::Boolean("/", "merclb", "perform mercury load balancing", \$MERC_LOADBAL),
);

# string containing arguments to pass to master server
our $APP_MASTER_ARGS;

# string containing arguments to pass to slave server
our $APP_SLAVE_ARGS;

# function ref to process getopt parameters. You may change 
# $APP_MASTER_ARGS, $APP_SLAVE_ARGS, etc. in this function.
#
# the function is passed ($vservers, @logins)
# each $login is in the format 'user@host:iface'
our $APP_HANDLE_ARGS = sub {
    my $vservers = shift;
    my @logins   = map { [ split(/\@|:/, $_) ] } @_;
    my $nservers = $vservers * scalar @logins;

    my $VISUALIZER = $opt_z;
    my $BMARK      = $opt_H;
    my $BOTS       = $opt_b;
    my $MAP        = $opt_m;
    my $AOISIZE    = $opt_i;
    my $FRAMELIM   = $opt_f;
    my $TIMELIM    = $opt_e;
    my $DHT        = $opt_D;
    my $LOADINFO   = $opt_I;
    my $MIGRATE    = $opt_Q;

    my $common_args = 
        "--maxdislat '$MAXDISLAT' " .
	"--pub-interval '$PUB_INTERVAL' " .
	"--sub-prediction-player '$SUB_PREDICTION' " .
	($VISUALIZER ? "--visualizer-ip '$VISUALIZER' " : "") .
	($BMARK ? "--benchmark-patterns '$BMARK' " : "") .
        ($BOTS ? "--bots '$BOTS' " : "") .
	($MAP ? "--map '$MAP' " : "") .
	($AOISIZE ? "--aoisize '$AOISIZE' " : "") .
	($FRAMELIM ? "--framelimit '$FRAMELIM' " : "") .
	($TIMELIM ? "--timelimit '$TIMELIM' " : "") . 
	"--idletime " . ($nservers) . " ";
    

    my $merc_bounds;

    if (defined $DHT) {
	$common_args .= "--dht --regions-per-x '$DHT' ";
	if ($MAP !~ /rect/) { 
	    $common_args .= " --regions-per-y '$DHT' ";
	}
	else {
	    $common_args .= " --regions-per-y '4' ";
	}

	# XXX HACK: make sure these are the same as the schema!!!
	# when we use DHT regions, they first key is the DHT key, the
	# later two are the (x,y) coordinates (but they are still labeled y,z)
	$merc_bounds = "x -1000000000 1000000000,y -1000000000 1000000000,z -1000000000 1000000000";
    } else {
	# XXX HACK: make sure these are the same as the schema!!!
	$merc_bounds = "x -1000000000 1000000000,y -1000000000 1000000000";
    }

    if ($MIGRATE eq "region") {
	# build region map
	#my $regions_per_side = ceil( sqrt($nservers) );
	#my $regions = $regions_per_side*$regions_per_side;
	my $regions = $nservers;

	my $region_map = "";

	srand(42); # make permutation deterministic

	my @ids;
	for (my $i=0; $i<$regions; $i++) {
	    $ids[$i] = $i;
	}
	# permute
	for (my $i=0; $i<$regions; $i++) {
	    my $pick = int(rand($regions - 1 - $i));
	    my $last = $ids[$regions - 1 - $i];
	    $ids[$regions - 1 - $i] = $ids[$pick];
	    $ids[$pick] = $last;
	}
	# assign
	for (my $i=0; $i<$regions; $i++) {
	    my $s = $ids[$i] % $nservers;
	    my $serv = int($s/$vservers);
	    my $vindex = $s % $vservers;
	    my $addr = $logins[$serv]->[2];
	    my $port = $MERC_PORTS[$vindex] + 5000; # XXX HACK

	    $region_map .= "," if $i != 0;
	    $region_map .= "$i $addr:$port";
	}

	$common_args .= "--region-map '$region_map' ";
	$common_args .= "--regions-per-x '$regions' ";
	
	if (defined $DHT && $DHT != $regions) {
	    twarn "HEY! You are region migration which sets the regions-per-x to $regions\n" .
		"     This conflicts with the DHT region sides you chose ($DHT)\n" .
		"     YOU HAD BETTER KNOW WHAT YOU ARE DOING!!\n";
	}
    } 
    if ($MIGRATE eq "load" || $LOADINFO) {
	tdie "migrate mode set to 'load' but -I load info not enabled!" if 
	    ! $LOADINFO;

	# the two mercury attributes (x,load) come first so they are indexed (0,1)
	# the other matching attributes come later (only y if no DHT, (y,z) which is really
	# (x,y) if DHT is enabled. (XXX HACK)
	if (defined $DHT) {
	    $merc_bounds = "x -1000000000 1000000000,load -1000000000 1000000000,y -1000000000 1000000000,z -1000000000 1000000000";
	} else {
	    $merc_bounds = "x -1000000000 1000000000,load -1000000000 1000000000,y -1000000000 1000000000";
	}
    }

    srand ($$ ^ time);
    $common_args .= "--mercbounds '$merc_bounds' ";

    if (defined $MERC_LOADBAL) {
        tinfo "merc-loadbal defined. YAY!";
	$common_args .= " --sampling --selfhistos --loadbal-routeload --load-balance --load-balance-delta 2.0 ";
    }
    $APP_MASTER_ARGS = $common_args;
    $APP_SLAVE_ARGS  = $common_args;

    if ($LOADINFO) {
	$APP_SCHEMA = "schema_test_onehub_load.cfg";
    }

    #tinfo "args: $common_args";
    #exit 0;
};

# function that generates inividual args for each server. You may NOT change 
# $APP_MASTER_ARGS, $APP_SLAVE_ARGS, etc. in this function.
#
# the function is passed ($login, $virtual_server_index, $mercPort, \@logins, $VIRTUAL_SERVERS)
our $APP_INDIV_ARGS = sub {
    my $seed = int (rand (42000));
    return " --seed $seed ";
};

1;
