#
# Run.pl configuration for Mercapp
#

use strict;
use Travertine;
use Options;
use vars qw($opt_client $opt_trace $opt_trace_start $opt_store_opts
	    $opt_min_replicas $opt_initial_dir $opt_tcp_mesh $opt_keysize
	    $opt_waitjoin);

our $STOREPORT_BASE = 40000;

our @RPC_PORTS = 
    (12000,12001,12002,12003,12004,12005,12006,12007,12008,12009,
     12010,12011,12012,12013,12014,12015,12016,12017,12018,12019);

###############################################################################

our @APP_INST_DIST = (
      "Merc/build/bootstrap",
      "intel/defrag/build/store",
      "intel/defrag/build/*.cfg",
      "intel/defrag/build/initial_data",
      "intel/defrag/build/traces",
      "intel/defrag/*.so",
      "Merc/build/chkjoin2",
      "Merc/build/*.conf",
      "Merc/*.so",
      "Merc/util/time-test/client",
      "Merc/util/time-test/server",

      "Merc/scripts/Topology2Waspnet.pl",
      "Merc/topologies/emulab.*",
      "Merc/run/emulab/util",
);

our $APP_INST_PRE = sub {
    my $topdir = shift;
    my $username = shift;
    
    psystem("sudo mkdir -p $topdir");
    psystem("sudo chown $username $topdir");
};

our $APP_INST_POST = sub {
    my $topdir = shift;
    my $username = shift;

    psystem("sudo mkdir -p $topdir/db");
    psystem("sudo chown $username $topdir/db");
};

# directory containing $APP_EXE in relation to $TOPDIR
# our $APP_DIR = "Merc/apps/testgame";
our $APP_DIR = "intel/defrag/build";

# application executable name in $TOPDIR/$APP_DIR
our $APP_EXE = "store";

# library path (to libcolyseus) rlt to $TOPDIR/$APP_DIR
our $APP_LIBPATH = "..:../../../Merc";

# path to bootstrap exe rlt to $TOPDIR/$APP_DIR
our $APP_BOOTSTRAP = "../../../Merc/build/bootstrap";

# path to artificial topologies (i.e. ../Merc/topologies)
our $APP_TOPODIR = "../../../Merc/topologies";

# default application mercury schema (may be changed)
our $APP_SCHEMA = ""; # set later

our $APP_PARAMS_CONF = "../../../Merc/build/params.conf";
#our $APP_PARAMS_CONF = "../../../Merc/build/params_defrag.conf";

our $APP_TOPO2WASPNET = "../../../Merc/scripts/Topology2Waspnet.pl";

###############################################################################

# application script parameters (passed to perl script)
our @APP_OPT_TABLE = (
 #Options::String("#", "client", "store client {term,trace,none}", \$opt_client, "term"),
 Options::String("#", "key-size", "key size (must have schema!)", \$opt_keysize, "512"), 
 Options::String("#", "tcp-mesh", "init tcp mesh with servers in this file", \$opt_tcp_mesh, ""), 
 Options::String("#", "min-replicas", "minimum replicas", \$opt_min_replicas, "4"),
 Options::String("#", "trace-dir", "trace dir for each trace client (from defrag/build/traces", \$opt_trace, "test"),
 Options::String("#", "trace-start", "trace start time for trace client", \$opt_trace_start, "0.0"),
 Options::String("#", "initial-dir", "directory (from defrag/build/initial_data) containing initial data", \$opt_initial_dir, ""),
 Options::String("#", "store-opts", "other common store arguments", \$opt_store_opts, ""),
);

# string containing arguments to pass to master server
our $APP_MASTER_ARGS;

# string containing arguments to pass to slave server
our $APP_SLAVE_ARGS;

our $APP_BOOTSTRAP_ARGS;

our $APP_NSERVERS;
our %ABS_SERVER_INDEX;
our %ABS_SERVER_INDEX_REV;

our @TRACE_FILES;

our $APP_TOPDIR;

# function ref to process getopt parameters. You may change 
# $APP_MASTER_ARGS, $APP_SLAVE_ARGS, etc. in this function.
#
# the function is passed ($vservers, @logins)
# each $login is in the format 'user@host:iface'
our $APP_HANDLE_ARGS = sub {
    my $vservers = shift;
    my @logins   = map { [ split(/\@|:/, $_) ] } @_;
    $APP_NSERVERS = $vservers * scalar @logins;
    $APP_TOPDIR = $opt_t || "/tmp";

    my $abs_index = 0;
    # allocate nodes in round robin order across machines, in case the
    # input files have nodes in ring order (this will spread succs across
    # different machines to distribute load)
    for (my $j=0; $j<$vservers; $j++) {
	for (my $i=0; $i<@logins; $i++) {
	    
	    my $port = $STOREPORT_BASE + $j;
	    my $addr = $logins[$i]->[2] . ":" . $port;
	    $ABS_SERVER_INDEX{ $addr } = $abs_index;
	    $ABS_SERVER_INDEX_REV{ $abs_index } = $addr;
	    $abs_index++;   
	}
    }

    my $common = "$opt_store_opts --nosuccdebug --use-local-merc --store-min-replicas $opt_min_replicas --store-key-size $opt_keysize --store-db-fake ";
    #if (!$opt_waitjoin) {
    #	$common .= " --no-merc-alljoin ";
    #}
    # force this for stability

    if (defined $opt_tcp_mesh && $opt_tcp_mesh ne "") {
	$common .= " --tcp-mesh $opt_tcp_mesh ";
    }

    $APP_MASTER_ARGS = $APP_SLAVE_ARGS = $common;

    $APP_SCHEMA = "schema_defrag.$opt_keysize.cfg";

    #$APP_MASTER_ARGS = "$common --store-client term";
    #$APP_MASTER_ARGS = "$common --store-client trace,term --store-client-trace-file traces/$opt_trace --store-client-trace-start-time $opt_trace_start";
    #$APP_SLAVE_ARGS  = "$common --store-client term";

    # xxx: hack the path
    @TRACE_FILES = glob("../../intel/defrag/build/traces/$opt_trace/session_trace.*.log");
    tdie "no trace files in $opt_trace" if !@TRACE_FILES;

    foreach my $t (@TRACE_FILES) {
	$t =~ s|../../intel/defrag/build|.|;
    }
    my $nclients = scalar @TRACE_FILES;
    tinfo "$nclients trace clients, will use " . ($nclients > $APP_NSERVERS ? $APP_NSERVERS : $nclients) . " of them";

    if (defined $opt_initial_dir && $opt_initial_dir ne "") {
	# make the ident map for this config
	# open(I, "$LOCAL_TOP_DIR/$APP_DIR/initial_data/$opt_initial_dir/ident.map") or
# 	    tdie `pwd` . "can't open ident map file: $LOCAL_TOP_DIR/$APP_DIR/initial_data/$opt_initial_dir/ident.map";
# 	open(O, ">/tmp/ident.map");
# 	while (<I>) {
# 	    chomp;
# 	    if ($_ =~ /(\d+)\s+([0-9a-fA-F]+)/) {
# 		my ($index, $id) = ($1, $2);
# 		my $addr = $ABS_SERVER_INDEX_REV{$index};
# 		if (!$addr) {
# 		    tdie "missing addr for node $index ($id)";
# 		}
# 		print O "0\t$addr\t$id\n";
# 	    } else {
# 		twarn "bad line in ident map: $_";
# 	    }
# 	}
# 	close(I);
# 	close(O);

	#$APP_BOOTSTRAP_ARGS = " --ident-map /tmp/ident.map ";
	$APP_BOOTSTRAP_ARGS = " --ident-map initial_data/$opt_initial_dir/ident.map --policy ident-map";
	# force this for stability
	if (!$opt_waitjoin) {
	    $APP_BOOTSTRAP_ARGS .= " --nservers $APP_NSERVERS ";
	}
    }
};

# function that generates inividual args for each server. You may NOT change 
# $APP_MASTER_ARGS, $APP_SLAVE_ARGS, etc. in this function.
#
# the function is passed ($login, $virtual_server_index, $mercPort, \@logins, $VIRTUAL_SERVERS)
our $APP_INDIV_ARGS = sub {
    my @login = split(/\@|:/, shift());
    my $vindex = shift;
    my $port = $STOREPORT_BASE + $vindex;

    my $addr = $login[2] . ":" . $port;
    my $aindex = $ABS_SERVER_INDEX{ $addr };
    if (!defined $aindex) {
	tdie "missing absolute index for @login vserver $vindex";
    }

    my $dbname = "$APP_TOPDIR/db/store.$login[2].$port.db";

    my $opts = " --store-rpc-port $port --store-db-name $dbname ";
    if (defined $opt_initial_dir && $opt_initial_dir ne "") {
	my @files;
	for (my $i=0; $i<$opt_min_replicas+1; $i++) {
	    my $index = ($aindex - $i) % $APP_NSERVERS;

	    push @files, "initial_data/$opt_initial_dir/store.log.$index";
	}
	$opts .= " --store-initial-data-files " . join(",", @files) . 
	    " --store-initial-data-size-file initial_data/$opt_initial_dir/preimage.log ";
    }

    if ($aindex < @TRACE_FILES) {
	$opts .= " --store-client trace,term --store-client-trace-file $TRACE_FILES[$aindex] --store-client-trace-start-time $opt_trace_start --store-client-delay 0";
    } else {
	$opts .= " --store-client term ";
    }

    return $opts;
};

1;
