#
# Run.pl configuration for Mercapp
#

use strict;
use Travertine;
use Options;
use vars qw($opt_z $opt_H $opt_b $opt_w $opt_m $opt_f $opt_i $opt_e);

our @RPC_PORTS = 
    (12000,12001,12002,12003,12004,12005,12006,12007,12008,12009,
     12010,12011,12012,12013,12014,12015,12016,12017,12018,12019);

###############################################################################

# directory containing $APP_EXE in relation to $TOPDIR
# our $APP_DIR = "Merc/apps/testgame";
our $APP_DIR = "intel/defrag/build";

# application executable name in $TOPDIR/$APP_DIR
our $APP_EXE = "rpcserver";

# library path (to libcolyseus) rlt to $TOPDIR/$APP_DIR
our $APP_LIBPATH = "..:../../../Merc";

# path to bootstrap exe rlt to $TOPDIR/$APP_DIR
our $APP_BOOTSTRAP = "../../../Merc/build/bootstrap";

# path to artificial topologies (i.e. ../Merc/topologies)
our $APP_TOPODIR = "../../../Merc/topologies";

# default application mercury schema (may be changed)
our $APP_SCHEMA = "../../../Merc/build/schema_defrag.cfg";

our $APP_PARAMS_CONF = "../../../Merc/build/params.conf";

###############################################################################

# application script parameters (passed to perl script)
our @APP_OPT_TABLE = ();

# string containing arguments to pass to master server
our $APP_MASTER_ARGS;

# string containing arguments to pass to slave server
our $APP_SLAVE_ARGS;

# function ref to process getopt parameters. You may change 
# $APP_MASTER_ARGS, $APP_SLAVE_ARGS, etc. in this function.
#
# the function is passed ($vservers, @logins)
# each $login is in the format 'user@host:iface'
our $APP_HANDLE_ARGS = sub {
    $APP_MASTER_ARGS = "";
    $APP_SLAVE_ARGS  = "";
};

# function that generates inividual args for each server. You may NOT change 
# $APP_MASTER_ARGS, $APP_SLAVE_ARGS, etc. in this function.
#
# the function is passed ($login, $virtual_server_index, $mercPort, \@logins, $VIRTUAL_SERVERS)
our $APP_INDIV_ARGS = sub {
    my $login = shift;
    my $vindex = shift;

    return " --rpc-port $RPC_PORTS[$vindex] ";
};

1;
