#
# Run.pl configuration for Quake2
#

use strict;
use Options;
use Travertine;
use vars qw($opt_b $opt_M $opt_F $opt_e $opt_p $opt_i $opt_S $opt_D $opt_z
	    $opt_m $opt_d $opt_maxclients);

# XXX HACK -- this must be in synch with RunV2.pl
our @MERC_PORTS   = (20000, 20001, 20002, 20003, 20004, 20005, 20006, 20007,
                     20008, 20009, 20010, 20011, 20012, 20013, 20014, 20015,
                     20016, 20017, 20018, 20019, 20020, 20021, 20022, 20023,
                     20024, 20025, 20026, 20027, 20028, 20029, 20030, 20031,
                     20032, 20033, 20034, 20035, 20036, 20037, 20038, 20039,);

our @QUAKE_PORTS = 
    (27910,27911,27912,27913,27914,27915,27916,27917,27918,27919,
     27920,27921,27922,27923,27924,27925,27926,27927,27928,27929,
     27930,27931,27932,27933,27934,27935,27936,27937,27938,27939,);

# How to linearize map [ stripe_dim, stripes_x, stripes_y, stripes_z ]
our %STRIPE_MAP = 
    ( "big_map" => [ "y", 4, 1, 1 ],
      "big_map4" => [ "y", 4, 1, 4 ] );

our $BOTS_ON_MASTER = 1;

###############################################################################
# The files to copy over to the remote host (relative to TOPDIR)
# (may be globs of files, but not of nested directories: ../*/*.. doesn't work)
# Do NOT include trailing slashes
#
our @APP_INST_DIST = (
      "baseq2",
      "id-source/debugi386/*.so",
      "id-source/quake2",
      "id-source/quake2.conf",
      "id-source/bbox",
      "Merc/build/bootstrap",
      "Merc/build/chkjoin2",
      "Merc/build/params.conf",
      "Merc/build/*.cfg",
      "Merc/*.so",
      "Merc/topologies/*.lat",
      "Merc/util/time-test/client",
      "Merc/util/time-test/server",
      "Merc/scripts/Topology2Waspnet.pl",
      "Merc/topologies/emulab.*",
      "Merc/run/emulab/util",
	);

# Function to execute on remote host before sync
#
our $APP_INST_PRE = sub {
    my $topdir = shift;
    my $username = shift;

    psystem("sudo mkdir -p $topdir");
    psystem("sudo chown $username $topdir");
};

# Function to execute on the remote host after sync
#
our $APP_INST_POST = sub {
    my $topdir = shift;

    my %links =
	( "id-source/baseq2" => "$topdir/baseq2" ); 
         #( "id-source/baseq2" => "/proj/DNA/jeffpang/baseq2" ); 

    chdir($topdir) or twarn "can't chdir $topdir";
    foreach my $from (keys %links) {
	psystem "rm -f $from";
	psystem "ln -sf $links{$from} $from";
    }

    psystem "cp -f $topdir/Merc/build/params.conf $topdir/id-source";

    # chmod to correct permissions
    psystem("chmod -R g+rw $topdir/Merc >/dev/null 2>&1");
   
    # for stupid bittorrent which does not keep the permissions :(
    # or perhaps for stupid me who cant figure out how to make it 
    # preserve them. - Ashwin [08/21/2005]
    
    foreach my $prog ("Merc/build/bootstrap", "Merc/build/chkjoin2", 
		      "id-source/quake2") 
    {
        psystem("chmod +x $topdir/$prog");
    }
};


# directory containing $APP_EXE in relation to $TOPDIR
our $APP_DIR = "id-source";

# application executable name in $TOPDIR/$APP_DIR
our $APP_EXE = "quake2";

# library path (to libcolyseus) rlt to $TOPDIR/$APP_DIR
our $APP_LIBPATH = ".:../Merc";

# path to bootstrap exe rlt to $TOPDIR/$APP_DIR
our $APP_BOOTSTRAP = "../Merc/build/bootstrap";

# path to artificial topologies (i.e. ../Merc/topologies)
our $APP_TOPODIR = "../Merc/topologies";

# default application mercury schema (may be changed)
our $APP_SCHEMA = ""; # set later in APP_HANDLE_ARGS;

our $APP_PARAMS_CONF = "../Merc/build/params.conf";

###############################################################################
our $DO_MEASUREMENT;
our $MERC_LOADBAL = "";
our $ENABLE_STRIPING = undef;

# application script parameters (passed to perl script)
our @APP_OPT_TABLE = 
(
 Options::String("m", "map", "map name", \$opt_m, undef),
 Options::String("b", "nbots", "number of bots on each server", \$opt_b, undef),
 Options::String("M", "nmons", "number of monsters on each server", \$opt_M, undef),
 Options::String("#", "maxclients", "max players allowed on each server", \$opt_maxclients, "64"),
 Options::Boolean("F", "nofight", "dont fight monsters (normal DM)", \$opt_F),
 Options::Boolean("p", "nopred", "no event/interest prediction", \$opt_p),
 Options::String("i", "itempar", "how to partition items", \$opt_i, undef),
 Options::String("e", "timelimit", "time limit in msec", \$opt_e, undef),
 Options::Boolean("/", "stripe",  "enable striping", \$ENABLE_STRIPING),
 Options::String("S", "stripedim", "do striping along this dimension", \$opt_S, undef),
 Options::Boolean("D", "dht", "use DHT style pubs-subs", \$opt_D),
 Options::String("z", "vis-ip", "visualizer IP addr", \$opt_z, undef),
 Options::Boolean("d", "deltas", "use --deltas", \$opt_d),
 Options::Boolean("/", "merclb", "perform mercury load balancing", \$MERC_LOADBAL)
);

# string containing arguments to pass to master server
our $APP_MASTER_ARGS;

# string containing arguments to pass to slave server
our $APP_SLAVE_ARGS;

# function ref to process getopt parameters. You may change 
# $APP_MASTER_ARGS, $APP_SLAVE_ARGS, etc. in this function.
#
# the function is passed ($vservers, @logins)
# each $login is in the format 'user@host:iface'
our $APP_HANDLE_ARGS = sub {
    my $vservers  = shift;
    my @servers   = @_;
    my $nservers  = scalar(@_)*$vservers;

    my $MAP               = $opt_m || "big_map";
    my $NUMBOTS           = defined $opt_b ? $opt_b : 1;
    my $NUMMONSTERS       = defined $opt_M ? $opt_M : 1;
    my $NO_FIGHT_MONSTERS = defined $opt_F;

    my $TIMELIMIT         = $opt_e || 1000000000;
    my $ENABLE_PREDICTION = 1; $ENABLE_PREDICTION = 0 if (defined $opt_p);
    my $ITEM_PARTITIONING = defined $opt_i ? $opt_i : 'b';
    my $STRIPE_DIM        = $opt_S;
    my $DHT               = defined $opt_D;
    my $VISUALIZER        = $opt_z;
    my $DELTAS            = defined $opt_d;
    my $ROUTING_HUBS      = "y";  # XXX must agree with the schema file XXX

    if ($ENABLE_STRIPING && !defined $STRIPE_DIM) {
	$STRIPE_DIM = $STRIPE_MAP{$MAP}->[0] if defined $STRIPE_MAP{$MAP};
    }
    
    if (!$ENABLE_STRIPING && !$DHT) {
	$APP_SCHEMA = "../Merc/build/schema_quake_onehub.cfg";
    }
    else {
	$APP_SCHEMA = "../Merc/build/schema_quake_stripe.cfg";
	$ROUTING_HUBS = "k";
    }

    ##########

    my $pred_args = "";
    if (!$ENABLE_PREDICTION) {
	$pred_args = 
	    " --subttl_player 100 --subttl_monster 100 --subttl_missile 100 " .
	    " --pubttl_player 100 --pubttl_monster 100 --pubttl_missile 100" .
	    " --subpred_player 0 --subpred_monster 0 --subpred_missile 0" .
	    " --pubpred_player 0 --pubpred_monster 0 --pubpred_missile 0";
    }

    my $dht_args = "";
    if ($DHT) {
	$dht_args = " --dht --dht_buckets 100 --dht_hub x ";
	$STRIPE_DIM = '';
    }

    my $delta_args = "";
    if ($DELTAS) {
	$delta_args = " --deltas";
    }

    my $monster_args = " --fightmonsters +set sv_playerhealth 1000 " .
	"+set sv_monsterhealth 100 +set sv_scalehealthitem 10.0 ";
    if ($NO_FIGHT_MONSTERS) {
	$monster_args = 
	    " +set sv_playerhealth 500 +set sv_scalehealthitem 5.0 ";
    }

    my $visualizer_args = "";
    if ($VISUALIZER) {
	$visualizer_args = " --visualizer-ip '$VISUALIZER' ";
    }

    my $stripe_args = "";
    if ($ENABLE_STRIPING) {
	if ($STRIPE_MAP{$MAP}) {
	    my @s = @{$STRIPE_MAP{$MAP}};
	    $stripe_args = " --stripes_x $s[1] --stripes_y $s[2] --stripes_z $s[3] ";
	} else {
	    twarn "stripping on $STRIPE_DIM but no spec for map $MAP; using defaults";
	}
    }

    # xxx let nservers = 75% of nservers so we tolerate some startup errors
    my $waitfor = int($nservers*0.75);
    my $common_args =
	"--nservers $waitfor " .
	"--timelimit $TIMELIMIT " .
	"--spawn_type t " . 
	"--item-partition $ITEM_PARTITIONING " .
	"--stripe_dim '$STRIPE_DIM' " .
	"$pred_args " .
	"$dht_args " .
	"$delta_args " .
	"$monster_args " .
	"$visualizer_args " .
	"$stripe_args " .
	"+set dedicated 1 +set nostdout 0 " . #+exec server.cfg " .
	"+set maxentities 2048 +set maxclients $opt_maxclients " .
	"+map $MAP --bbox-file bbox/$MAP.bbox ";

    my (undef, undef, $master) = 
	($servers[0] =~ /^([^\@]+)\@([^:]+):([^:]+)$/);
    tdie "bad master login: $servers[0]" if !$master;


    my $merc_bounds = "x -1000000000 1000000000,y -1000000000 1000000000,z -1000000000 1000000000";
    if ($DHT || $STRIPE_DIM ne "") {
	$merc_bounds = "k -1000000000 1000000000,$merc_bounds";
    }
    $common_args .= " --mercbounds '$merc_bounds' --routing_hubs $ROUTING_HUBS";
    if (defined $MERC_LOADBAL) {
        tinfo "merc-loadbal defined. YAY!";
	$common_args .= " --sampling --selfhistos --loadbal-routeload --load-balance --load-balance-delta 2.0 ";
    }

    if ($DO_MEASUREMENT) {
	$common_args .= " --record-obj-deltas --record-obj-interests ";
    }

    $APP_MASTER_ARGS = "$common_args --master ";
    if ($BOTS_ON_MASTER) {
	$APP_MASTER_ARGS .= " --nbots $NUMBOTS --nmonsters $NUMMONSTERS ";
    }

    $APP_SLAVE_ARGS = "$common_args --master-ip $master " .
	"--nbots $NUMBOTS --nmonsters $NUMMONSTERS ";

    tinfo "slave args [$APP_SLAVE_ARGS]";
};

# function that generates inividual args for each server. You may NOT change 
# $APP_MASTER_ARGS, $APP_SLAVE_ARGS, etc. in this function.
#
# the function is passed ($login, $virtual_server_index, $mercPort, \@logins, $VIRTUAL_SERVERS)
our $APP_INDIV_ARGS = sub {
    my $login = shift;
    my $vindex = shift;

    return " +set port $QUAKE_PORTS[$vindex] ";
};

1;
