#!/usr/bin/perl
use strict;

BEGIN {
    $ENV{TRAVERTINE_SSHVERSION} = "1,2";
    $ENV{TRAVERTINE_PRINTCMDS} = 1;
};

use Travertine;

our @logins = ();
foreach my $i (0 .. 29) { 
    push @logins, "ashwin\@node$i.lan-30.dna.emulab.net:node$i";
}

sub SplitLogin($)
{
    my $login = shift;
    
    my ($user, $host, $iface) = ($login =~ /^([^\@]+)\@([^:]+):([^:]+)$/);
    die "bad login: $login" if !$user || !$host || !$iface;

    #$host  = ResolveIP($host);
    #$iface = ResolveIP($iface);

    return ($user, $host, $iface);
}

our @ssh = ParallelExec2(sub {
    my $login = shift;
    my ($user, $host, $iface) = SplitLogin($login);
    my $ssh = Travertine::SSHTunnel->new($user, $host);
    tdie "can't open connection to $login" if !$ssh;
    return $ssh;
}, @logins);

ParallelExec3 (10, sub {
	my ($ssh) = shift @_;
	ExecRemoteFunc($ssh, sub {
	    psystem ("rm -rf /home/ashwin/Merc");
	    }, [], -print => 1, -timeout => 300);
	}, @ssh);
