////////////////////////////////////////////////////////////////////////////////
// Mercury and Colyseus Software Distribution 
// 
// Copyright (C) 2004-2005 Ashwin Bharambe (ashu@cs.cmu.edu)
//               2004-2005 Jeffrey Pang    (jeffpang@cs.cmu.edu)
//                    2004 Mukesh Agrawal  (mukesh@cs.cmu.edu)
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2, or (at
// your option) any later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA
////////////////////////////////////////////////////////////////////////////////

#include <Mercury.h>
#include <om/ManagerParams.h>
#include <om/OMEvent.h>
#include <om/OMInterest.h>
#include <om/OMMessage.h>
#include <util/Options.h>


OptionType g_ManagerParamsOpts[] = {
    ///// OBJECT MANAGEMENT PARAMETERS

    { '#', "pubdeltas", OPT_NOARG | OPT_BOOL,
      "publish deltas in the first pub from new objects", 
      &(ManagerParams::PUBLISH_NEW_DELTAS), "0",
      (void *) "1"},

    { '#', "proactive", OPT_NOARG | OPT_BOOL,
      "proactively replicate attached objects", 
      &(ManagerParams::PROACTIVE_REPLICATION), "0",
      (void *) "1"},

    { '#', "mercbounds", OPT_STR,
      "bounds on merc attributes, given as \"min max\" tuples (comma separated)", 
      ManagerParams::MERC_ATTR_BOUNDS_STR, "", NULL},

    { 'L', "loadinfo", OPT_NOARG | OPT_BOOL,
      "enable load info exchange", 
      &(ManagerParams::ENABLE_LOAD_INFO), "0",
      (void *) "1"},

    { '#', "loadinfo-hub", OPT_STR,
      "name of mercury hub used for load info searches", 
      ManagerParams::LOAD_INFO_HUB, "load", NULL},

    { '#', "loadinfo-bcast", OPT_NOARG | OPT_BOOL,
      "broadcast load info instead of using mercury (debugging)", 
      &(ManagerParams::BROADCAST_LOAD_INFO), "0",
      (void *) "1" },
    { '#', "loadinfo-bcast-port", OPT_INT,
      "broadcast load info local port", 
      &(ManagerParams::BROADCAST_LOAD_INFO_PORT), "80000",
      NULL },
    { '#', "loadinfo-bcast-others", OPT_STR,
      "broadcast load info list of hosts (comma separated host:port)", 
      ManagerParams::BROADCAST_LOAD_INFO_OTHERS, "", NULL},

    { 'M', "migrate", OPT_STR,
      "migration policy {static,rand,region,load}", 
      ManagerParams::PLACEMENT_POLICY, "static", NULL},

    { 'M', "region-map", OPT_STR,
      "region map for region based placement policy (comma separated \"r sid\" pairs)", 
      ManagerParams::REGION_MAP_STR, "", NULL},

    { 'f', "freq", OPT_NOARG | OPT_BOOL,
      "run all maintenance each during each iteration", 
      &(ManagerParams::FREQUENT_MAINTENANCE), "0",
      (void *) "1"},

    { 'c', "config", OPT_STR,
      "Manager config file", ManagerParams::CONFIG_FILE,
      "", NULL},

    { '#', "omopts", OPT_STR,
      "same as config but a comma separated list of VAR=VAL pairs", 
      ManagerParams::CONFIG_OPTS, "", NULL},

    { '#', "term-passwd", OPT_STR,
      "terminal password required for login ('' = none)",
      ManagerParams::TERMINAL_PASSWORD, "", NULL},

    { 'W', "waitjoin", OPT_NOARG | OPT_BOOL,
      "wait for all expected nodes to join merc", 
      &(ManagerParams::WAIT_ALL_JOIN), "0",
      (void *) "1"},

    { '#', "checkinv", OPT_NOARG | OPT_BOOL,
      "periodically check invariants (expensive)", 
      &(ManagerParams::CHECK_INVARIANTS), "0", (void *) "1"},

    {0, 0, 0, 0, 0, 0, 0}
};

void InitializeColyseus(int *pArgc, char *argv[], OptionType appOptions[], bool printOptions)
{
    OptionType *opts;
    if (appOptions == NULL) {
	opts = g_ManagerParamsOpts;
    } else {
	int mlen = 0, alen = 0;
	for ( ; g_ManagerParamsOpts[mlen].longword ; mlen++)
	    ;
	for ( ; appOptions[alen].longword ; alen++)
	    ;
	opts = new OptionType[mlen + alen + 1];
	memcpy(opts, g_ManagerParamsOpts, mlen*sizeof(OptionType));
	memcpy(opts+mlen, appOptions, alen*sizeof(OptionType));
	bzero(opts+mlen+alen, sizeof(OptionType));
    }

    InitializeMercury(pArgc, argv, opts, printOptions);

    if (appOptions != NULL) delete[] opts;

    OM_RegisterMessageTypes ();
    OM_RegisterEventTypes ();
    OM_RegisterInterestTypes ();
}
// vim: set sw=4 sts=4 ts=8 noet: 
// Local Variables:
// Mode: c++
// c-basic-offset: 4
// tab-width: 8
// indent-tabs-mode: t
// End:
