////////////////////////////////////////////////////////////////////////////////
// Mercury and Colyseus Software Distribution 
// 
// Copyright (C) 2004-2005 Ashwin Bharambe (ashu@cs.cmu.edu)
//               2004-2005 Jeffrey Pang    (jeffpang@cs.cmu.edu)
//                    2004 Mukesh Agrawal  (mukesh@cs.cmu.edu)
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2, or (at
// your option) any later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA
////////////////////////////////////////////////////////////////////////////////
/* -*- Mode:c++; c-basic-offset:4; tab-width:4; indent-tabs-mode:t -*- */

/**************************************************************************
  common.h

begin           : Oct 16, 2003
version         : $Id: common.h 2382 2005-11-03 22:54:59Z ashu $
copyright       : (C) 2003      Jeff Pang        ( jeffpang@cs.cmu.edu )
(C) 2003      Justin Weisz     (  jweisz@cs.cmu.edu  )

***************************************************************************/

#ifndef __COMMON_H__
#define __COMMON_H__

#include <set>
#include <vector>
#include <list>
#include <map>

#ifdef _WIN32
#include <hash_map>
#include <hash_set>
#else
#include <hash_map.h>
#include <hash_set.h>
#endif

#include <iostream>
#include <string>
#include <cstdlib>
#include <cstdio>
#include <cmath>
#include <typeinfo>

#ifndef _WIN32
#include <sys/time.h>
#include <time.h>
#else
#include <WinSock2.h>  // Guess, this will include the require timeval structures etc... - Ashwin
#endif

#include <util/types.h>
#include <mercury/common.h>
#include <mercury/Packet.h>
#include <util/TimeVal.h>
#include <mercury/ID.h>

    using namespace std;

// buffer size when reading in lines
#define LINEBUF_SIZE 256

// cost metric used for optimization; in future we will want more than one
// value? e.g., represents consumed bandwidth (bytes per sec)
typedef float CostMetric;
// bandwidth in bytes/sec
typedef float bwidth_t;
#define SERIALIZE_BWIDTH(pkt, val) ((pkt)->WriteFloat(val))
#define DESERIALIZE_BWIDTH(pkt, lhs) (lhs = (pkt)->ReadFloat())

///////////////////////////////////////////////////////////////////////////////
// hash functions
struct hash_ptr {
    hash<uint32> H;

    size_t operator() (const void *a) const {
	return H((uint32)a);
    }
};

struct equal_ptr {
    bool operator() ( const void *a, const void *b ) const {
	return a == b;
    }
};

struct less_ptr {
    bool operator() ( const void *a, const void *b ) const {
	return (uint32)a < (uint32)b;
    }
};

struct hash_string {
    hash<const char *> h;

    int operator()(const string& str) const {
	return h(str.c_str());
    }
};

//////////////////////////////////////////////////////////////////////////////

class OMEvent;
class OMInterest;
class GObject;

typedef set<OMEvent *> EventSet;
typedef EventSet::iterator EventSetIter;

typedef set<OMInterest *> InterestSet;
typedef InterestSet::iterator InterestSetIter;

typedef map<GUID, OMEvent *, less_GUID> EventMap;
typedef EventMap::iterator EventMapIter;

typedef list<OMEvent *> EventList;
typedef EventList::iterator EventListIter;

typedef list<OMInterest *> InterestList;
typedef InterestList::iterator InterestListIter;

typedef map<GUID, OMInterest *, less_GUID> InterestMap;
typedef InterestMap::iterator InterestMapIter;

typedef map<GUID, GObject *, less_GUID> GObjectMap;
typedef GObjectMap::iterator GObjectMapIter;

typedef vector<GObject *> GObjectVec;
typedef GObjectVec::iterator GObjectIter;

typedef multimap<GUID, GUID, less_GUID> GUIDMap;
typedef GUIDMap::iterator GUIDMapIter;

// XXX TODO: should be more flexible than just guid
typedef set<GUID, less_GUID> Tags;

extern SID g_LocalSID;
//////////////////////////////////////////////////////////////////////////////

#endif
// vim: set sw=4 sts=4 ts=8 noet: 
// Local Variables:
// Mode: c++
// c-basic-offset: 4
// tab-width: 8
// indent-tabs-mode: t
// End:
