////////////////////////////////////////////////////////////////////////////////
// Mercury and Colyseus Software Distribution 
// 
// Copyright (C) 2004-2005 Ashwin Bharambe (ashu@cs.cmu.edu)
//               2004-2005 Jeffrey Pang    (jeffpang@cs.cmu.edu)
//                    2004 Mukesh Agrawal  (mukesh@cs.cmu.edu)
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2, or (at
// your option) any later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA
////////////////////////////////////////////////////////////////////////////////
/* -*- Mode:c++; c-basic-offset:4; tab-width:4; indent-tabs-mode:t -*- */

/**************************************************************************

begin           : Nov 8, 2003
version         : $Id: OMLogs.h 2476 2005-11-13 06:31:08Z jeffpang $
copyright       : (C) 2003      Jeff Pang        ( jeffpang@cs.cmu.edu )
(C) 2003      Justin Weisz     (  jweisz@cs.cmu.edu  )

***************************************************************************/

#ifndef __OM_LOGS_H__
#define __OM_LOGS_H__

#include <mercury/IPEndPoint.h>
#include <mercury/ID.h>
#include <util/types.h>
#include <util/ExpLog.h>

    struct MigrationLogEntry : public ExpLogEntry
    {
	GUID guid;
	SID  to;

	MigrationLogEntry() {}
	MigrationLogEntry(const GUID& guid, const SID& to) :
	    guid(guid), to(to) {}
	virtual ~MigrationLogEntry() {};

	uint32 Dump(FILE *fp) {
	    return fprintf(fp, "%13.3f\t%s\t%s\n",
			   (double)time.tv_sec + 
			   (double)time.tv_usec/USEC_IN_SEC,
			   guid.ToString(), to.ToString());
	}
    };

struct RepConnSendDroppedEntry : public ExpLogEntry
{
    SID dest;
    uint16 sent, async, lost;
    float avg_window;

    RepConnSendDroppedEntry() {}
    RepConnSendDroppedEntry(const SID& dest, uint16 sent, uint16 async, uint16 lost, float avg_window) :
	dest(dest), sent(sent), async(async), lost(lost), avg_window(avg_window) {}
    
    uint32 Dump(FILE *fp) {
	return fprintf(fp, "%13.3f\t%s\t%d\t%d\t%d\t%.2f\n",
		       (double)time.tv_sec + 
		       (double)time.tv_usec/USEC_IN_SEC,
		       dest.ToString(), sent, async, lost, avg_window);
    }
};

struct RepConnRecvDroppedEntry : public ExpLogEntry
{
    SID dest;
    uint16 recv, missing, old;
    uint16 async, amissing, aold;

    RepConnRecvDroppedEntry() {}
    RepConnRecvDroppedEntry(const SID& dest, uint16 recv, uint16 missing, uint16 old, uint16 async, uint16 amissing, uint16 aold) :
	dest(dest), recv(recv), missing(missing), old(old), async(async), amissing(amissing), aold(aold) {}
    
    uint32 Dump(FILE *fp) {
	return fprintf(fp, "%13.3f\t%s\t%d\t%d\t%d\t%d\t%d\t%d\n",
		       (double)time.tv_sec + 
		       (double)time.tv_usec/USEC_IN_SEC,
		       dest.ToString(), recv, missing, old,
		       async, amissing, aold);
    }
};

struct RepConnSendEntry : public ExpLogEntry
{
    SID dest;
    sint32 interarrival;
    uint16 size;
    byte n, d, u;

    RepConnSendEntry() {}
    RepConnSendEntry(const SID& dest, sint32 interarrival, 
		     uint16 size, uint32 n, uint32 d, uint32 u) :
	dest(dest), interarrival(interarrival), size(size),
    n((byte)n), d((byte)d), u((byte)u) {}
    
    uint32 Dump(FILE *fp) {
	return fprintf(fp, "%13.3f\t%s\t%d\t%d\t%d\t%d\t%d\n",
		       (double)time.tv_sec + 
		       (double)time.tv_usec/USEC_IN_SEC,
		       dest.ToString(), interarrival, size,
		       (int)n, (int)d, (int)u);
    }
};

struct RepConnRecvEntry : public ExpLogEntry
{
    SID src;
    sint32 interarrival;
    uint16 size;
    byte n, d, u;

    RepConnRecvEntry() {}
    RepConnRecvEntry(const SID& src, sint32 interarrival, 
		     uint16 size, uint32 n, uint32 d, uint32 u) :
	src(src), interarrival(interarrival), size(size),
    n((byte)n), d((byte)d), u((byte)u) {}
    
    uint32 Dump(FILE *fp) {
	return fprintf(fp, "%13.3f\t%s\t%d\t%d\t%d\t%d\t%d\n",
		       (double)time.tv_sec + 
		       (double)time.tv_usec/USEC_IN_SEC,
		       src.ToString(), interarrival, size,
		       (int)n, (int)d, (int)u);
    }
};

///////////////////////////////////////////////////////////////////////////////

DECLARE_EXPLOG(MigrationLog, MigrationLogEntry);
DECLARE_EXPLOG(RepConnSendDroppedLog, RepConnSendDroppedEntry);
DECLARE_EXPLOG(RepConnRecvDroppedLog, RepConnRecvDroppedEntry);
DECLARE_EXPLOG(RepConnSendLog, RepConnSendEntry);
DECLARE_EXPLOG(RepConnRecvLog, RepConnRecvEntry);

extern void InitOMLogs(IPEndPoint sid);

#endif
// vim: set sw=4 sts=4 ts=8 noet: 
// Local Variables:
// Mode: c++
// c-basic-offset: 4
// tab-width: 8
// indent-tabs-mode: t
// End:
