////////////////////////////////////////////////////////////////////////////////
// Mercury and Colyseus Software Distribution 
// 
// Copyright (C) 2004-2005 Ashwin Bharambe (ashu@cs.cmu.edu)
//               2004-2005 Jeffrey Pang    (jeffpang@cs.cmu.edu)
//                    2004 Mukesh Agrawal  (mukesh@cs.cmu.edu)
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2, or (at
// your option) any later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA
////////////////////////////////////////////////////////////////////////////////
/* -*- Mode:c++; c-basic-offset:4; tab-width:4; indent-tabs-mode:t -*- */

/**************************************************************************

begin           : Nov 8, 2003
version         : $Id: OMLogs.cpp 2476 2005-11-13 06:31:08Z jeffpang $
copyright       : (C) 2003      Jeff Pang        ( jeffpang@cs.cmu.edu )
(C) 2003      Justin Weisz     (  jweisz@cs.cmu.edu  )

***************************************************************************/

#include <om/OMLogs.h>

    IMPLEMENT_EXPLOG(MigrationLog, MigrationLogEntry);
IMPLEMENT_EXPLOG(RepConnSendDroppedLog, RepConnSendDroppedEntry);
IMPLEMENT_EXPLOG(RepConnRecvDroppedLog, RepConnRecvDroppedEntry);
IMPLEMENT_EXPLOG(RepConnSendLog, RepConnSendEntry);
IMPLEMENT_EXPLOG(RepConnRecvLog, RepConnRecvEntry);

void InitOMLogs(IPEndPoint sid)
{
    ASSERT(g_MeasurementParams.enabled);
    ASSERT(sid != SID_NONE);

    if (!g_MigrationLog)
	INIT_EXPLOG(MigrationLog, sid);

    if (!g_RepConnSendDroppedLog)
	INIT_EXPLOG(RepConnSendDroppedLog, sid);

    if (!g_RepConnRecvDroppedLog)
	INIT_EXPLOG(RepConnRecvDroppedLog, sid);

    if (!g_RepConnSendLog)
	INIT_EXPLOG(RepConnSendLog, sid);

    if (!g_RepConnRecvLog)
	INIT_EXPLOG(RepConnRecvLog, sid);
}
// vim: set sw=4 sts=4 ts=8 noet: 
// Local Variables:
// Mode: c++
// c-basic-offset: 4
// tab-width: 8
// indent-tabs-mode: t
// End:
