////////////////////////////////////////////////////////////////////////////////
// Mercury and Colyseus Software Distribution 
// 
// Copyright (C) 2004-2005 Ashwin Bharambe (ashu@cs.cmu.edu)
//               2004-2005 Jeffrey Pang    (jeffpang@cs.cmu.edu)
//                    2004 Mukesh Agrawal  (mukesh@cs.cmu.edu)
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2, or (at
// your option) any later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA
////////////////////////////////////////////////////////////////////////////////

/**************************************************************************
  GUpdate.h

begin           : Nov 6, 2002
copyright       : (C) 2002-2003 Ashwin R. Bharambe ( ashu@cs.cmu.edu   )
(C) 2002-2003 Justin Weisz       ( jweisz@cs.cmu.edu )

***************************************************************************/

#ifndef __GUPDATE_H__
#define __GUPDATE_H__

#include <map>
#include <om/common.h>
#include <om/DeltaMask.h>
#include <util/Buffer.h>

    ///////////////////////////////////////////////////////////////////////////////

    struct GUpdate : public Serializable {
	static const int MAX_UPDATE_SIZE = 8192; //1400;

	bool isUpdate;    // true if replica -> primary
	bool isNew;       // true if this creates a new replica of the object
	bool isDelete;    // true if the action was to delete the object
	bool isProactive; // true if requesting proactive replication 
	GUID guid;        // update target
	DeltaMask mask;   // delta mask of the delta
	Packet *delta;    // actual data

	///// MEASUREMENT VARIABLES (see ObjectLogs.h)
	uint32 nonce;
	/////

	GUpdate();
	GUpdate(bool isUpdate, GUID guid);
	GUpdate(const GUpdate& other);
	virtual ~GUpdate();

	GUpdate(Packet *pkt);
	void Serialize(Packet *pkt);
	uint32 GetLength();
	void Print(FILE *stream);
    };

typedef map<GUID, GUpdate *, less_GUID> GUpdateMap;
typedef GUpdateMap::iterator GUpdateMapIter;

ostream& operator<<(ostream& out, GUpdate *update);

#endif
// vim: set sw=4 sts=4 ts=8 noet: 
// Local Variables:
// Mode: c++
// c-basic-offset: 4
// tab-width: 8
// indent-tabs-mode: t
// End:
