////////////////////////////////////////////////////////////////////////////////
// Mercury and Colyseus Software Distribution 
// 
// Copyright (C) 2004-2005 Ashwin Bharambe (ashu@cs.cmu.edu)
//               2004-2005 Jeffrey Pang    (jeffpang@cs.cmu.edu)
//                    2004 Mukesh Agrawal  (mukesh@cs.cmu.edu)
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2, or (at
// your option) any later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA
////////////////////////////////////////////////////////////////////////////////
/* -*- Mode:C++; c-basic-offset:4; tab-width:4; indent-tabs-mode:t -*- */

/***************************************************************************
  DirectRouter.h

  Simple router for sending events directly between hosts.

begin           : Nov 6, 2002
copyright       : (C) 2002-2003 Ashwin R. Bharambe ( ashu@cs.cmu.edu   )
(C) 2002-2003 Jeff Pang          ( jeffpang@cs.cmu.edu )

***************************************************************************/


#ifndef __DIRECT_ROUTER__H
#define __DIRECT_ROUTER__H

#include <list>
#include <util/Thread.h>
#include <mercury/Interest.h>
#include <mercury/Event.h>
#include <mercury/common.h>
#include <mercury/NetworkLayer.h>
#include <mercury/Router.h>
#include <mercury/BufferManager.h>
#include <mercury/IPEndPoint.h>
#include <wan-env/RealNet.h>
#include <wan-env/WANScheduler.h>
#include <om/common.h>
#include <util/debug.h>

    class Manager;
class Scheduler;
struct MsgApp;

/* XXX Eventually we will get rid of this and push the connection interface
   up to the client */
class DirectRouter : public Router {
 private:

    static DirectRouter *m_Instance;

    Manager *m_Manager;
    BufferManager *m_BufferManager;
    RealNet *m_Network;
    WANScheduler *m_Scheduler;

    IPEndPoint m_IP;
    bool m_Started;

 protected:

    DirectRouter(sid_t sid, Manager *handler);

 public:

    static DirectRouter *GetInstance(sid_t sid, Manager *handler);
    static DirectRouter *GetInstance();
    static void DestroyInstance() { 
	if (m_Instance)
	    delete m_Instance; 
	m_Instance = NULL; 
    }

    virtual ~DirectRouter();

    uint32 GetIP();
    unsigned short GetPort();
    RealNet *GetNetwork() { return m_Network; }

    void SendEvent(Event *); // DO NOT USE

    void SendMsg(IPEndPoint *target, MsgApp *, int protocol = (int) PROTO_UDP);
    void FreeMsg(MsgApp *);
    void RegisterInterest(Interest *); // DO NOT USE
    Event *ReadEvent(); // DO NOT USE
    MsgApp *ReadMsg();

    void LockBuffer(); // DO NOT USE
    void UnlockBuffer(); // DO NOT USE

    void Print(FILE *stream); // DO NOT USE

    void DoWork(u_long timeout);


    bwidth_t GetOutboundUsage(TimeVal& now);
    bwidth_t GetInboundUsage(TimeVal& now);
};

#endif
// vim: set sw=4 sts=4 ts=8 noet: 
// Local Variables:
// Mode: c++
// c-basic-offset: 4
// tab-width: 8
// indent-tabs-mode: t
// End:
