////////////////////////////////////////////////////////////////////////////////
// Mercury and Colyseus Software Distribution 
// 
// Copyright (C) 2004-2005 Ashwin Bharambe (ashu@cs.cmu.edu)
//               2004-2005 Jeffrey Pang    (jeffpang@cs.cmu.edu)
//                    2004 Mukesh Agrawal  (mukesh@cs.cmu.edu)
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2, or (at
// your option) any later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA
////////////////////////////////////////////////////////////////////////////////

/**************************************************************************
  DeltaMask.cpp

begin           : Nov 6, 2002
copyright       : (C) 2002-2003 Ashwin R. Bharambe ( ashu@cs.cmu.edu   )
(C) 2002-2003 Justin Weisz       ( jweisz@cs.cmu.edu )

***************************************************************************/

#include <om/DeltaMask.h>

    const DeltaMask DELTA_MASK_NONE;

DeltaMask::DeltaMask(Packet *pkt) { 
    Clear();
    while (true) {
	bits[max_word] = pkt->ReadInt();
	bool next = bits[max_word] & (1 << 31);
	bits[max_word] &= ~(1 << 31);
	if ( next ) {
	    max_word++;
	    continue;
	} else {
	    break;
	}
    }
}

void DeltaMask::Serialize(Packet *pkt) {
    for (int i=0; i<=max_word; i++) {
	int word = bits[i];
	if (i != max_word)
	    word |= (1 << 31);
	pkt->WriteInt(word);
    }
}

uint32 DeltaMask::GetLength() {
    return (max_word+1)*4;
}

void DeltaMask::Print(FILE *) {
    ASSERT(false);
}

ostream& operator<<(ostream& out, const DeltaMask& mask)
{
    bool comma = false;

    out << "[";
    for (int i=0; i<MAX_DELTA_FIELDS; i++) {
	if (mask.IsSet(i)) {
	    if (comma) out << ",";
	    out << i;
	    comma = true;
	}
    }
    out << "]";
    return out;
}
// vim: set sw=4 sts=4 ts=8 noet: 
// Local Variables:
// Mode: c++
// c-basic-offset: 4
// tab-width: 8
// indent-tabs-mode: t
// End:
