////////////////////////////////////////////////////////////////////////////////
// Mercury and Colyseus Software Distribution 
// 
// Copyright (C) 2004-2005 Ashwin Bharambe (ashu@cs.cmu.edu)
//               2004-2005 Jeffrey Pang    (jeffpang@cs.cmu.edu)
//                    2004 Mukesh Agrawal  (mukesh@cs.cmu.edu)
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2, or (at
// your option) any later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA
////////////////////////////////////////////////////////////////////////////////

/**************************************************************************
  ReplicaConnection.h

begin           : Nov 6, 2002
copyright       : (C) 2002-2004 Ashwin R. Bharambe ( ashu@cs.cmu.edu   )
(C) 2003-2004 Jeff Pang      ( jeffpang@cs.cmu.edu   )

***************************************************************************/

#ifndef __DELTA_INFO_H__
#define __DELTA_INFO_H__

#include <list>
#include <mercury/common.h>
#include <om/common.h>
#include <om/GObject.h>
#include <util/TimedStruct.h>
#include <om/ManagerParams.h>

    // This doesn't technically have to be soft-state because the remote node
    // should inform us when they are no longer interested in receiving updates
    // for this object; but keep a longer soft-state timer active anyway to handle
    // failures...
    struct DeltaInfo : public TimedStruct {
	DeltaMask mask;
	bool isNew;
	bool isDelete;
	bool isProactive;

	///// MEASUREMENT VARIABLES (see ObjectLogs.h)
	uint32 nonce;
	/////

	DeltaInfo();
	virtual ~DeltaInfo();

	inline void Merge(GUpdate *update) {
	    mask.Merge(update->mask);
	    isNew    |= update->isNew;
	    isDelete |= update->isDelete;
	    isProactive |= update->isProactive;
	}

	inline bool IsDirty() {
	    return isNew || isDelete || mask != DELTA_MASK_NONE;
	}

	inline void Clear() {
	    mask.Clear();
	    isNew    = false;
	    isDelete = false;
	    isProactive = false;
	}

	DeltaInfo(Packet *pkt);
	void Serialize(Packet *pkt);
	uint32 GetLength();
    };

ostream& operator<<(ostream& out, DeltaInfo *info);

typedef map<GUID, DeltaInfo, less_GUID> DeltaMap;
typedef DeltaMap::iterator DeltaMapIter;

typedef map<SID, DeltaInfo, less_SID> SIDDeltaMap;
typedef SIDDeltaMap::iterator SIDDeltaMapIter;

#endif
// vim: set sw=4 sts=4 ts=8 noet: 
// Local Variables:
// Mode: c++
// c-basic-offset: 4
// tab-width: 8
// indent-tabs-mode: t
// End:
