////////////////////////////////////////////////////////////////////////////////
// Mercury and Colyseus Software Distribution 
// 
// Copyright (C) 2004-2005 Ashwin Bharambe (ashu@cs.cmu.edu)
//               2004-2005 Jeffrey Pang    (jeffpang@cs.cmu.edu)
//                    2004 Mukesh Agrawal  (mukesh@cs.cmu.edu)
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2, or (at
// your option) any later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA
////////////////////////////////////////////////////////////////////////////////

/**************************************************************************
  TileWorld.h

begin           : Nov 6, 2002
copyright       : (C) 2002-2005 Ashwin R. Bharambe ( ashu@cs.cmu.edu   )
(C) 2002-2005 Jeffrey Pang       ( jeffpang@cs.cmu.edu )

***************************************************************************/

#include "TileWorld.h"

    TileChunk::TileChunk(const GUID& guid, int w, int h) : 
	StaticGameObject(guid), w(w), h(h)
{
    tiles = new Tile *[w];
    for (int i=0; i<h; i++)
	tiles[i] = new Tile[h];
}

TileChunk::~TileChunk()
{
    for (int i=0; i<h; i++)
	delete[] tiles[i];
    delete[] tiles;
}

TileChunk::TileChunk(Packet *pkt) :
    StaticGameObject(pkt)
{
    w = pkt->ReadInt();
    h = pkt->ReadInt();
    for (int i=0; i<w; i++) {
	for (int j=0; j<h; j++)
	    tiles[i][j] = Tile(pkt);
    }
}

void TileChunk::Serialize(Packet *pkt)
{
    StaticGameObject::Serialize(pkt);
    pkt->WriteInt(w);
    pkt->WriteInt(h);
    for (int i=0; i<w; i++) {
	for (int j=0; j<h; j++)
	    tiles[i][j].Serialize(pkt);
    }
}

uint32 TileChunk::GetLength()
{
    uint32 len = StaticGameObject::GetLength() + 4 + 4;
    if (w*h > 0) {
	len += w*h*tiles[0][0].GetLength();
    }
    return len;
}

///////////////////////////////////////////////////////////////////////////////

enum { L = 0, M = 1, R = 2 };
enum { T = 0,        B = 2 };

TileRegion::TileRegion(TileChunk *middle) : middle(middle)
{
}

Tile TileRegion::GetTile(int i, int j)
{
    // XXX TODO
    return Tile();
}

///////////////////////////////////////////////////////////////////////////////

TileWorld::TileWorld(BBox dimensions, int chunksize) :
    dims(dimensions), chunksize(chunksize)
{
    // XXX TODO
}

TileWorld::~TileWorld()
{
    for (ChunkMapIter it = chunks.begin(); it != chunks.end(); it++) {
	delete it->second;
    }
}

void TileWorld::Link(GameObject *obj)
{
    // XXX TODO
}

void TileWorld::Unlink(GameObject *obj)
{
    // XXX TODO
}

uint32 TileWorld::GetAreaOfInterest(list<BBox> *toFill, DynamicGameObject *obj)
{
    // XXX TODO
    return 0;
}

void TileWorld::DoWork()
{
    // XXX TODO
}
// vim: set sw=4 sts=4 ts=8 noet: 
// Local Variables:
// Mode: c++
// c-basic-offset: 4
// tab-width: 8
// indent-tabs-mode: t
// End:
