////////////////////////////////////////////////////////////////////////////////
// Mercury and Colyseus Software Distribution 
// 
// Copyright (C) 2004-2005 Ashwin Bharambe (ashu@cs.cmu.edu)
//               2004-2005 Jeffrey Pang    (jeffpang@cs.cmu.edu)
//                    2004 Mukesh Agrawal  (mukesh@cs.cmu.edu)
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2, or (at
// your option) any later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA
////////////////////////////////////////////////////////////////////////////////

/**************************************************************************

begin           : Nov 6, 2002
copyright       : (C) 2002-2005 Ashwin R. Bharambe ( ashu@cs.cmu.edu   )
(C) 2002-2005 Jeffrey Pang       ( jeffpang@cs.cmu.edu )

***************************************************************************/

#ifndef __SIMPLE_GAME_H__
#define __SIMPLE_GAME_H__

#include <gameapi/GameModule.h>
#include "PredictiveInterestFilter.h"
#include "DHTInterestFilter.h"

    class SimpleGame : public GameModule {
    private:
    DHTHasher *m_Hasher;
    static bool m_Inited;
    public:
    // frame interval (ms) (inverse frame rate)
    static uint32 frameInterval;
    // publication interval
    static uint32 pubInterval;
    // max discovery latency (for prediction fudge)
    static uint32 maxDisLat;
    // interest prediction parameters
    static PredictiveParams predictionParams;
    // if true, publications and subscriptions will be generated
    // as DHT region keys instead of merc range queries
    static bool publishAsDHTRegions;

    static void SetPubInterval(uint32 msec) {
	ASSERT(!m_Inited);
	pubInterval = msec;
    }

    static void SetMaxDisLat(uint32 msec) {
	ASSERT(!m_Inited);
	maxDisLat = msec;
    }

    static bool IsInited() {
	return m_Inited;
    }

    virtual const uint32 FrameInterval() { return frameInterval; }
    virtual gRetCode Init(GameManager *manager);
    virtual gRetCode RunFrame(GameManager *manager);
    virtual gRetCode Shutdown(GameManager *manager);
    virtual DynamicGameObject *ConstructObject(gTypeCode type,
					       GObjectInfoIface *info);
    virtual GameObject *ConstructObject(Packet *pkt);
    virtual void DeleteObject(DynamicGameObject *obj);

    DHTHasher *GetHasher() {
	ASSERT(publishAsDHTRegions);
	return m_Hasher;
    }
};

#endif
// vim: set sw=4 sts=4 ts=8 noet: 
// Local Variables:
// Mode: c++
// c-basic-offset: 4
// tab-width: 8
// indent-tabs-mode: t
// End:
