////////////////////////////////////////////////////////////////////////////////
// Mercury and Colyseus Software Distribution 
// 
// Copyright (C) 2004-2005 Ashwin Bharambe (ashu@cs.cmu.edu)
//               2004-2005 Jeffrey Pang    (jeffpang@cs.cmu.edu)
//                    2004 Mukesh Agrawal  (mukesh@cs.cmu.edu)
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2, or (at
// your option) any later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA
////////////////////////////////////////////////////////////////////////////////

/**************************************************************************

begin           : Nov 6, 2002
copyright       : (C) 2002-2005 Ashwin R. Bharambe ( ashu@cs.cmu.edu   )
(C) 2002-2005 Jeffrey Pang       ( jeffpang@cs.cmu.edu )

***************************************************************************/

#include <gameapi/GameManager.h>
#include <gameapi/GameStore.h>
#include <gameapi/GameObject.h>
#include <util/Benchmark.h>
#include "SimpleTypeCodes.h"
#include "SimpleGame.h"
#include "SimpleMovable.h"
#include "SimplePlayer.h"
#include "SimpleMissile.h"

    uint32 SimpleGame::frameInterval = 100;
uint32 SimpleGame::pubInterval   = 1000;
uint32 SimpleGame::maxDisLat     = 300;

bool SimpleGame::m_Inited = false;

PredictiveParams SimpleGame::predictionParams;

bool SimpleGame::publishAsDHTRegions = false;

gRetCode SimpleGame::Init(GameManager *manager)
{
    ASSERT(!m_Inited);
    m_Inited = true;

    if (publishAsDHTRegions)
	m_Hasher = new DHTHasher(0);
    else
	m_Hasher = NULL;

#if 0	
    if (g_Preferences.slowdown_factor > 1.0f) {
#undef scale_by_factor
#define scale_by_factor(var) var = (uint32) (var * g_Preferences.slowdown_factor);
	scale_by_factor (SimpleGame::frameInterval);
	scale_by_factor (SimpleGame::pubInterval); 

	scale_by_factor (maxDisLat);

	scale_by_factor(SimplePlayer::SUB_PREDICTION);
	scale_by_factor(SimpleMissile::SUB_PREDICTION);

	ASSERT (SimpleGame::frameInterval > 0);
	ASSERT (SimpleGame::pubInterval > 0);
#undef scale_by_factor
    }
#endif

    predictionParams =
	PredictiveParams( SimplePlayer::WALK_VELOCITY, 
			  // maxVelocity -- ignore missiles for now
			  0.0, // locRadius
			  SimpleGame::pubInterval, // pubInterval
			  SimpleGame::frameInterval, // timeUnit
			  maxDisLat ); // maxDiscoveryLat

    INFO << "Scaled Game Parameters:" << endl;
    INFO << "SimpleGame::frameInterval\t" << SimpleGame::frameInterval << endl;
    INFO << "SimpleGame::pubInterval\t" << SimpleGame::pubInterval << endl;
    INFO << "SimpleGame::predictionParams.maxVelocity\t" << SimpleGame::predictionParams.maxVelocity << endl;
    INFO << "SimpleGame::predictionParams.locRadius\t" << SimpleGame::predictionParams.locRadius << endl;
    INFO << "SimpleGame::predictionParams.pubInterval\t" << SimpleGame::predictionParams.pubInterval << endl;
    INFO << "SimpleGame::predictionParams.timeUnit\t" << SimpleGame::predictionParams.timeUnit << endl;
    INFO << "SimpleGame::predictionParams.maxDiscoveryLat\t" << SimpleGame::predictionParams.maxDiscoveryLat << endl;
    INFO << "SimplePlayer::SUB_PREDICTION\t" << SimplePlayer::SUB_PREDICTION << endl;
    INFO << "SimpleMissile::SUB_PREDICTION\t" << SimpleMissile::SUB_PREDICTION << endl;

    return GAME_OK;
}

gRetCode SimpleGame::RunFrame(GameManager *manager)
{
    GameStore *store = manager->GetStore();
    uint32 delta = 
	(manager->ThisFrameTime() - manager->LastFrameTime())/FrameInterval();

    DynamicGameObject *obj;

    //DB(1) << "frame: " << manager->GetFrameNumber() << ": " 
    //	  << store->Size() << endl;

    // run think code
    store->BeginDynamic();
    while ((obj = store->NextDynamic()) != NULL) {
	if (!obj->IsReplica()) {
	    obj->RunThink(manager, delta);
	}
#if 0
	if (manager->GetFrameNumber() % 10 == 0) {
	    cout << manager->GetFrameNumber() << ": ";
	    switch ( obj->GetType() ) {
	    case SIMPLE_PLAYER:
		cout << static_cast<SimplePlayer *>(obj) << endl;
	    default:
		cout << obj << endl;
	    }
	}
#endif
    }

    // remove deleted objects (can't do it above since that would mutate
    // the iterator while we are iterating through it)
    list<DynamicGameObject *> deleted;
    store->BeginDynamic();
    while ((obj = store->NextDynamic()) != NULL) {
	SimpleMovable *mov = static_cast<SimpleMovable *>(obj);
	if (mov->IsDeleted())
	    deleted.push_back(mov);
    }
    for (list<DynamicGameObject *>::iterator it = deleted.begin();
	 it != deleted.end(); it++) {
	store->Remove((*it)->GetGUID());
	DeleteObject(*it);
    }

    return GAME_OK;
}

gRetCode SimpleGame::Shutdown(GameManager *manager)
{
    return GAME_OK;
}

DynamicGameObject *SimpleGame::ConstructObject(gTypeCode type,
					       GObjectInfoIface *info)
{
    switch(type) {
    case SIMPLE_MOVABLE:
	return new SimpleMovable(info);
    case SIMPLE_PLAYER:
	return new SimplePlayer(info);
    case SIMPLE_MISSILE:
	return new SimpleMissile(info);
    default:
	WARN << "unknown SimpleObject typecode: " << type << endl;
	ASSERT(0);
    }

    return NULL;
}

GameObject *SimpleGame::ConstructObject(Packet *pkt)
{
    ASSERT(0);
    return NULL;
}

void SimpleGame::DeleteObject(DynamicGameObject *obj)
{
    delete obj;
}
// vim: set sw=4 sts=4 ts=8 noet: 
// Local Variables:
// Mode: c++
// c-basic-offset: 4
// tab-width: 8
// indent-tabs-mode: t
// End:
