////////////////////////////////////////////////////////////////////////////////
// Mercury and Colyseus Software Distribution 
// 
// Copyright (C) 2004-2005 Ashwin Bharambe (ashu@cs.cmu.edu)
//               2004-2005 Jeffrey Pang    (jeffpang@cs.cmu.edu)
//                    2004 Mukesh Agrawal  (mukesh@cs.cmu.edu)
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2, or (at
// your option) any later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA
////////////////////////////////////////////////////////////////////////////////

/**************************************************************************

begin           : Nov 6, 2002
copyright       : (C) 2002-2005 Ashwin R. Bharambe ( ashu@cs.cmu.edu   )
(C) 2002-2005 Jeffrey Pang       ( jeffpang@cs.cmu.edu )

***************************************************************************/

#ifndef __NULL_DATASOURCE_H__
#define __NULL_DATASOURCE_H__

#include <util/debug.h>
#include <gameapi/GameDatabase.h>

    class NullDataSource : public GameDataSource {
    public:

    virtual ~NullDataSource() {}

    virtual bool CanLoad(const GUID& globalID) { return false; }

    virtual bool CanStore(GameObject *obj) { return false; }

    virtual EventToken *Preload(const GUID& globalID, uint32 prio = 0) {
	ASSERT(0);
	return NULL;
    }

    virtual GameObject *Load(const GUID& globalID, uint32 prio = 0) {
	ASSERT(0);
	return NULL;
    }

    virtual EventToken *Store(GameObject *obj, uint32 prio = 0) {
	ASSERT(0);
	return NULL;
    }

    virtual void FreeToken(EventToken *tok) {
	ASSERT(0);
    }
};

#endif
// vim: set sw=4 sts=4 ts=8 noet: 
// Local Variables:
// Mode: c++
// c-basic-offset: 4
// tab-width: 8
// indent-tabs-mode: t
// End:
