////////////////////////////////////////////////////////////////////////////////
// Mercury and Colyseus Software Distribution 
// 
// Copyright (C) 2004-2005 Ashwin Bharambe (ashu@cs.cmu.edu)
//               2004-2005 Jeffrey Pang    (jeffpang@cs.cmu.edu)
//                    2004 Mukesh Agrawal  (mukesh@cs.cmu.edu)
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2, or (at
// your option) any later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA
////////////////////////////////////////////////////////////////////////////////

/**************************************************************************
  EmptyWorld.h

begin           : Nov 6, 2002
copyright       : (C) 2002-2005 Ashwin R. Bharambe ( ashu@cs.cmu.edu   )
(C) 2002-2005 Jeffrey Pang       ( jeffpang@cs.cmu.edu )

***************************************************************************/

#ifndef __EMPTY_WORLD_H__
#define __EMPTY_WORLD_H__

#include <mercury/common.h>
#include <util/Benchmark.h>
#include "SpaceWorld.h"


    class EmptyWorld : public SpaceWorld {
    private:
    // XXX TODO: parition into oct-tree
    set<GameObject *> objs;

    BBox dims; // of world
    BBox aoi;  // around origin

    public:

    const BBox& GetExtent() { return dims; }

    EmptyWorld(BBox dims, BBox aoi) : dims(dims), aoi(aoi) {};
    virtual ~EmptyWorld() {};

    virtual void Link(GameObject *obj) {
	START(temp::link);
	objs.insert(obj);
	STOP(temp::link);
    }
    virtual void Unlink(GameObject *obj) {
	objs.erase(obj);
    }
    virtual void Update(GameObject *obj) {}
    virtual uint32 GetAreaOfInterest(list<BBox> *toFill, 
				     DynamicGameObject *obj);

    ///////////////////////////////////////////////////////////////////////////

    /**
     * Fly a bbox through space until it hits something.
     */
    bool Fly(const BBox& vol,
	     const Vec3& start,
	     const Vec3& end,
	     Vec3 &hit_pt,
	     GameObject *& hit_obj,
	     GameObject *ignore = NULL);

    /**
     * Fly a point through space passing through other objects until it hits
     * a wall or something.
     */
    bool FlyThrough(const Vec3& start,
		    const Vec3& end,
		    Vec3 &hit_pt);

    void Trace(TraceResult& res, 
	       const BBox& ext, const Vec3& start, const Vec3& end,
	       const TraceFilterFunc& ignoreFunc, 
	       uint32 contentMask = TRACE_ALL);
    void Trace(TraceResult& res, 
	       const BBox& ext, const Vec3& start, const Vec3& end,
	       GameObject *ignore = NULL, 
	       uint32 contentMask = TRACE_ALL) {
	SpaceWorld::Trace(res, ext, start, end, ignore, contentMask);
    }

    Vec3 GetRandomPoint();
    void GetVisible(list<GameObject *> *vis, 
		    DynamicGameObject *obj,
		    const TraceFilterFunc& ignoreFunc);
    void GetVisible(list<GameObject *> *vis, 
		    DynamicGameObject *obj,
		    GameObject *ignore = NULL) {
	SpaceWorld::GetVisible(vis, obj, ignore);
    }
    bool IsVisible(DynamicGameObject *from, const Vec3& to,
		   list<BBox> *from_aoi = NULL);
  };

#endif
// vim: set sw=4 sts=4 ts=8 noet: 
// Local Variables:
// Mode: c++
// c-basic-offset: 4
// tab-width: 8
// indent-tabs-mode: t
// End:
