////////////////////////////////////////////////////////////////////////////////
// Mercury and Colyseus Software Distribution 
// 
// Copyright (C) 2004-2005 Ashwin Bharambe (ashu@cs.cmu.edu)
//               2004-2005 Jeffrey Pang    (jeffpang@cs.cmu.edu)
//                    2004 Mukesh Agrawal  (mukesh@cs.cmu.edu)
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2, or (at
// your option) any later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA
////////////////////////////////////////////////////////////////////////////////

/**************************************************************************
  GameManager.h

  Top-level interface to the game application.

begin           : Nov 6, 2002
copyright       : (C) 2002-2005 Ashwin R. Bharambe ( ashu@cs.cmu.edu   )
(C) 2002-2005 Jeffrey Pang       ( jeffpang@cs.cmu.edu )

***************************************************************************/

#ifndef __GAME_MODULE_H__
#define __GAME_MODULE_H__

#include <gameapi/common.h>
#include <gameapi/GameObject.h>

    class GameManager;

/**
 * This is the primary interface to the game code. It contains a series of
 * game-specific callbacks that are called when running the game.
 */
class GameModule {
 public:
    virtual ~GameModule () {}

    virtual const uint32 FrameInterval() = 0;

    virtual gRetCode Init(GameManager *manager) = 0;

    virtual gRetCode RunFrame(GameManager *manager) = 0;

    virtual gRetCode Shutdown(GameManager *manager) = 0;


    // construct a baseline replica
    virtual DynamicGameObject *ConstructObject(gTypeCode type,
					       GObjectInfoIface *info) = 0;

    // construct some thing from complete serialized form
    virtual GameObject *ConstructObject(Packet *pkt) = 0;

    virtual void DeleteObject(DynamicGameObject *obj) = 0;
};

#endif
// vim: set sw=4 sts=4 ts=8 noet: 
// Local Variables:
// Mode: c++
// c-basic-offset: 4
// tab-width: 8
// indent-tabs-mode: t
// End:
