#!/bin/sh
#
# This is a simple demo that shows the model game workload. It starts up
# $NSERVERS on the localhost and runs 4 bots on each. It then starts up
# the visualizer to view the bots in action. When the visualizer exits,
# the experiment is killed.
#
# NOTE: you must be able to 'ssh localhost' without a password. For example,
# load your public key into ssh-agent and add it to ~/.ssh/authorized_keys.

NSERVERS=4
BASE=`dirname $0`;

# in topdir
cd $BASE/.. || exit -1

# (1) run some servers
cd run || exit -1
./RunV2.pl TestgameConf.pl -B --nolat --nolog -v $NSERVERS -z 127.0.0.1 --mapdir ../apps/mapgen/maps/16-players --nbots 4 127.0.0.1 > /tmp/modelgame.demo1.exp || exit -1

# (2) start the visualizer
cd ../apps/viz
./viz --no-links --map ../mapgen/maps/16-players

# (3) kill the experiment
cd ../../run
./RunV2.pl TestgameConf.pl -k 127.0.0.1
