#!/usr/bin/perl

use strict;
use Getopt::Std;
use vars qw($opt_r $opt_g $opt_x $opt_y);

getopts("r:g:x:y:");

my $RADIUS = $opt_r || 1;
my $GOAL_PROB = $opt_g || 0.05;
my $XMAX = defined $opt_x ? $opt_x : 200;
my $YMAX = defined $opt_y ? $opt_y : $XMAX;

my %vmap;

my %vertices;
my @edges;

my $id = 0;
while(<>) {
    chomp $_;
    if ($_ =~ /([\d\.]+) ([\d\.]+) ([\d\.]+) ([\d\.]+)/) {
	my ($x1, $y1, $x2, $y2) = ($1, $2, $3, $4);

	next if $x1 < 0 || $x1 >= $XMAX;
	next if $y1 < 0 || $y1 >= $YMAX;
	next if $x2 < 0 || $x2 >= $XMAX;
	next if $y2 < 0 || $y2 >= $YMAX;

	my $v1 = "$x1 $y1";
	my $v2 = "$x2 $y2";

	my($i1, $i2);

	if (!defined $vertices{$v1}) {
	    $vertices{$v1} = $id++;
	}
	$i1 = $vertices{$v1};

	if (!defined $vertices{$v2}) {
	    $vertices{$v2} = $id++;
	}
	$i2 = $vertices{$v2};

	push @edges, [$i1, $i2];
	push @edges, [$i2, $i1];
    }
}

my $numvertices = scalar keys %vertices;
my $numedges = scalar @edges;

print "$numvertices $numedges\n";

# make vertices in random order
my @vertices = sort { $vertices{$a} <=> $vertices{$b} } keys %vertices;
my $index = 0;
my @indices = map { $index++ } @vertices;

my($last,$pick,$i); 
for ($i=0; $i<@indices; $i++) {
    $pick = $i + int(rand(@vertices - $i));
    $last = $indices[$i];
    $indices[$i] = $indices[$pick];
    $indices[$pick] = $last;

    $vmap{$indices[$i]} = $i;
}


my $index = 0;
my $hasgoal = 0;
foreach my $i (@indices) {
    my $v = $vertices[$i];
    # if we didn't choose any goals force the last one to be a goal
    my $isgoal = (rand() < $GOAL_PROB || 
		  !$hasgoal && $index == @indices-1 ? 1 : 0);
	!$hasgoal && $index == @indices-1;
    $hasgoal = $hasgoal || $isgoal;
    print "$v 0.0 $RADIUS $isgoal\n";
    $index++;
}

foreach my $e (@edges) {
    my $i = $vmap{$e->[0]};
    my $j = $vmap{$e->[1]};
    print "$i $j\n";
}
