package edu.cmu.cs.ark.compuframes.types;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.GZIPInputStream;

import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.math3.util.FastMath;

@Deprecated
public abstract class ModelOutput
{
  protected int epoch_count, term_count, ideo_count;
  protected String[] terms_array;
  protected String[] ideologies_array;
  protected String[] epoches_array;

  // terms_index[0] is __START_OF_SPEECH__
  // terms_index[-1] is last word of speech
  // terms_lag[0] is 0
  // terms_lag[-1] is lag at the end of speech
  // terms_lag[i] is lag between word i-1 and i
  protected int[][][] terms_index;
  protected int[][][] terms_lag;

  // array for holding parameters
  protected double[][] emission_hyper;
  protected double[][] stop_probs;
  protected double[][] continue_probs;
  protected double alpha, gamma;

  // array for holding current iteration samples
  protected int[][][] sample_x;
  protected boolean[][][] sample_r;

  // array for holding counts
  protected int[][] n_ideowords;
  protected int[][] n_endstate;
  protected int[][][] n_transitions;

  // array for caching normalization stuff
  protected double[] Z_emission_hyper;
  protected double[][] Z_transition_hyper;

  // array for holding saved counts
  protected int[][] save_ideowords;
  protected int[][] save_endstate;
  protected int[][][] save_transitions;

  // first and last vertices are start and end points anyway
  private int[][][] tree_paths;
  private static final int IDEO_ROOT = 0;

  private final double[] restart_table;
  private final double[] norestart_table;

  public ModelOutput()
  {
    restart_table = new double[1024];
    norestart_table = new double[1024];
    for (int i = 0; i < restart_table.length; i++)
    {
      double r = FastMath.pow(1.0 - gamma, (i + 1) / 50.0);
      restart_table[i] = FastMath.log(1.0 - r);
      norestart_table[i] = FastMath.log(r);

      if (Double.isNaN(restart_table[i]) || Double.isInfinite(restart_table[i]))
        restart_table[i] = -1e5;
      if (Double.isNaN(norestart_table[i]) || Double.isInfinite(norestart_table[i]))
        norestart_table[i] = -1e5;
    }
  }

  public void loadGzipSerializedData(File serialized_file) throws ClassNotFoundException, IOException
  {
    ObjectInput bis = new ObjectInputStream(new GZIPInputStream(new FileInputStream(serialized_file)));

    alpha = bis.readDouble();
    gamma = bis.readDouble();

    terms_array = (String[]) bis.readObject(); // terms_array
    term_count = terms_array.length;

    ideologies_array = (String[]) bis.readObject(); // ideologies_array
    ideo_count = ideologies_array.length;

    epoches_array = (String[]) bis.readObject(); // epoches_array
    epoch_count = epoches_array.length;

    terms_index = (int[][][]) bis.readObject(); // terms_index
    terms_lag = (int[][][]) bis.readObject(); // terms_lag

    stop_probs = (double[][]) bis.readObject();
    continue_probs = (double[][]) bis.readObject(); // continue_probs

    sample_r = (boolean[][][]) bis.readObject();
    sample_x = (int[][][]) bis.readObject();

    n_endstate = (int[][]) bis.readObject();
    n_ideowords = (int[][]) bis.readObject();
    n_transitions = (int[][][]) bis.readObject();

    emission_hyper = (double[][]) bis.readObject();
    Z_emission_hyper = (double[]) bis.readObject();
    Z_transition_hyper = (double[][]) bis.readObject();

    save_ideowords = (int[][]) bis.readObject();
    save_endstate = (int[][]) bis.readObject();
    save_transitions = (int[][][]) bis.readObject();

    tree_paths = new int[ideo_count][ideo_count][];
    setupTreePaths(new File("ideology.tree"));

    bis.close();
  }

  private void setupTreePaths(File ideology_file) throws IOException
  {
    List<String[]> ideology_pairs = new ArrayList<String[]>();

    BufferedReader br = new BufferedReader(new FileReader(ideology_file));

    br.readLine();

    for (int i = 0; i < ideo_count; i++)
      br.readLine(); // skip the ideologies name

    String line;
    while ((line = br.readLine()) != null)
    {
      if (line.isEmpty() || line.startsWith("#"))
        continue;
      ideology_pairs.add(line.split(" ", 2));
    }

    br.close();

    boolean[][] adj_matrix = new boolean[ideo_count][ideo_count];

    for (String[] edge : ideology_pairs)
    {
      int i = ArrayUtils.indexOf(ideologies_array, edge[0]);
      int j = ArrayUtils.indexOf(ideologies_array, edge[1]);
      adj_matrix[i][j] = true;
      adj_matrix[j][i] = true;
    }

    for (int u = 0; u < ideo_count; u++)
    {
      LinkedList<Integer> q = new LinkedList<>();
      LinkedList<Integer> q_from = new LinkedList<>();
      boolean[] visited = new boolean[ideo_count];
      q.add(u);
      q_from.add(-1);
      tree_paths[u][u] = new int[1];
      tree_paths[u][u][0] = u;

      while (!q.isEmpty())
      {
        int v = q.pop();
        int from = q_from.pop();

        if (v != u)
        {
          tree_paths[u][v] = new int[tree_paths[u][from].length + 1];
          for (int i = 0; i < tree_paths[u][from].length; i++)
            tree_paths[u][v][i] = tree_paths[u][from][i];
          tree_paths[u][v][tree_paths[u][from].length] = v;
        }

        visited[v] = true;

        for (int w = 0; w < ideo_count; w++)
          if (adj_matrix[v][w] && !visited[w])
          {
            q.add(w);
            q_from.add(v);
          }
      }
    }
    // int i = 9;
    // int j = 4;
    // System.out.println(ideologies_array[i]);
    // System.out.println(ideologies_array[j]);
    // System.out.println(ArrayUtils.toString(tree_paths[i][j]));
  }
}
