/**
 * 
 */
package edu.cmu.cs.ark.compuframes.types;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.apache.commons.io.FileUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

/**
 * @author Yanchuan Sim
 * @version 0.1
 * @since 0.1
 */
public class EpochData
{
  public final String name;
  public List<List<Pair<String, Integer>>> speeches = new ArrayList<List<Pair<String, Integer>>>();
  public List<String> speech_titles = new ArrayList<String>();

  public EpochData(File epoch_dir) throws IOException
  {
    name = epoch_dir.getName();

    Collection<File> file_list = FileUtils.listFiles(epoch_dir, new IOFileFilter()
    {
      @Override
      public boolean accept(File file)
      {
        return file.getName().endsWith(".lag");
      }

      @Override
      public boolean accept(File dir, String name)
      {
        return false;
      }
    }, null);

    // Collections.sort((List<File>) file_list, new Comparator<File>()
    // {
    // @Override
    // public int compare(File o1, File o2)
    // {
    // return o1.getAbsolutePath().compareTo(o2.getAbsolutePath());
    // }
    // });

    for (File f : file_list)
    {
      List<Pair<String, Integer>> speech_lags = new ArrayList<Pair<String, Integer>>();

      LineIterator it = FileUtils.lineIterator(f);
      while (it.hasNext())
      {
        String line = it.nextLine();
        if (line.startsWith("#") || line.isEmpty())
          continue;

        String[] fields = line.split(" |\t", 2);
        speech_lags.add(new ImmutablePair<String, Integer>(fields[0], Integer.parseInt(fields[1])));
      }
      it.close();

      speeches.add(speech_lags);
      speech_titles.add(f.getName().replaceFirst("\\.lag$", ""));
    }
  }
}
