/**
 * 
 */
package edu.cmu.cs.ark.compuframes;

/**
 * @author Yanchuan Sim
 * @version 0.1
 * @since 0.1
 */
import java.io.File;
import java.io.FileFilter;

import org.apache.commons.io.FilenameUtils;

public class AppState
{
  private final File base_dir;
  private File cur_state_dir;

  public AppState(File base_dir)
  {
    this.base_dir = base_dir;
  }

  public void createState(String id)
  {
    cur_state_dir = new File(FilenameUtils.concat(base_dir.getPath(), id));
    cur_state_dir.mkdir();
  }

  public void createState(int id)
  {
    createState(String.format("%05d", id));
  }

  public File getCurStateDirectory()
  {
    return cur_state_dir;
  }

  public File getCurStateFile(String filename)
  {
    return new File(FilenameUtils.concat(cur_state_dir.getPath(), filename));
  }

  public File getBaseDirFile(String filename)
  {
    return new File(FilenameUtils.concat(base_dir.getPath(), filename));
  }

  public boolean gotoLatestState()
  {
    int max_id = 0;
    for (File state_dir : base_dir.listFiles(new FileFilter()
    {
      @Override
      public boolean accept(File f)
      {
        return f.isDirectory();
      }
    }))
    {
      try
      {
        if (Integer.parseInt(state_dir.getName()) > max_id)
          max_id = Integer.parseInt(state_dir.getName());
      }
      catch (NumberFormatException nfe)
      {
        continue;
      }
    }

    if (max_id == 0)
      return false;

    createState(max_id);

    return true;
  }
}
