/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.ark.yc.config;

import com.martiansoftware.jsap.CommandLineTokenizer;
import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.stringparsers.FileStringParser;
import edu.cmu.cs.ark.yc.config.stringparsers.PositiveDoubleStringParser;
import edu.cmu.cs.ark.yc.config.stringparsers.PositiveIntegerStringParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;

public class AppConfig
extends JSAP {
    public static final PositiveIntegerStringParser POSITIVE_INTEGER_PARSER = new PositiveIntegerStringParser();
    public static final PositiveDoubleStringParser POSITIVE_DOUBLE_PARSER = new PositiveDoubleStringParser();
    private static final JSAPResult help_result = new JSAPResult(){

        @Override
        public boolean success() {
            return false;
        }
    };
    private final String name;
    private final String description;
    private final boolean enable_config;

    public AppConfig(String name, String description) {
        this.name = name;
        this.description = description;
        this.enable_config = false;
        try {
            this.registerParameter(new Switch("help", 'h', "help", "Displays this usage information."));
        }
        catch (JSAPException e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public AppConfig(String name, String description, boolean enableConfigFile) {
        this.name = name;
        this.description = description;
        this.enable_config = enableConfigFile;
        try {
            this.registerParameter(new Switch("help", 'h', "help", "Displays this usage information."));
            if (enableConfigFile) {
                this.registerParameter(new FlaggedOption("config-file", FileStringParser.getParser().setMustExist(true).setMustBeFile(true), null, false, '\u0000', "config-file", "Load configutation options from here."));
            }
        }
        catch (JSAPException e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public AppConfig(String name, String description, boolean enableConfigFile, boolean addHelpArgument) {
        this.name = name;
        this.description = description;
        this.enable_config = enableConfigFile;
        try {
            if (addHelpArgument) {
                this.registerParameter(new Switch("help", 'h', "help", "Displays this usage information."));
            }
            if (enableConfigFile) {
                this.registerParameter(new FlaggedOption("config-file", FileStringParser.getParser().setMustExist(true).setMustBeFile(true), null, false, '\u0000', "config-file", "Load configutation options from here."));
            }
        }
        catch (JSAPException e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    @Override
    public JSAPResult parse(String cmdLine) {
        return this.parse(CommandLineTokenizer.tokenize(cmdLine));
    }

    @Override
    public JSAPResult parse(String[] args) {
        JSAPResult result = super.parse(args);
        if (result.contains("help") && result.getBoolean("help")) {
            this.displayUsage();
            return help_result;
        }
        if (this.enable_config && result.contains("config-file")) {
            try {
                String[] config_commands = CommandLineTokenizer.tokenize(AppConfig.getArgumentsFromFile(result.getFile("config-file")));
                String[] combined_commands = new String[args.length + config_commands.length];
                int i = 0;
                while (i < args.length) {
                    combined_commands[i] = args[i];
                    ++i;
                }
                i = 0;
                while (i < config_commands.length) {
                    combined_commands[args.length + i] = config_commands[i];
                    ++i;
                }
                result = super.parse(combined_commands);
            }
            catch (IOException e) {
                result.addException("config-file", e);
            }
        }
        if (result.contains("help") && result.getBoolean("help")) {
            this.displayUsage();
            return help_result;
        }
        return result;
    }

    public void displayHelp(JSAPResult result) {
        Iterator iter = result.getBadParameterIDIterator();
        while (iter.hasNext()) {
            String id = (String)iter.next();
            Exception[] exceptionArray = result.getExceptionArray(id);
            int n = exceptionArray.length;
            int n2 = 0;
            while (n2 < n) {
                Exception e = exceptionArray[n2];
                System.err.format("%s: %s\n", id == null ? this.name : id, e.getMessage());
                ++n2;
            }
        }
        System.err.println();
        System.err.println("Use argument -h/--help to display detailed usage information.");
    }

    public void displayUsage() {
        System.err.format("Usage: %s %s\n", this.name, this.getUsage());
        System.err.println(this.description);
        System.err.println();
        System.err.println("Available options are:");
        System.err.println(this.getHelp());
    }

    public static String getArgumentsFromFile(File config_file) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(config_file), "utf-8"));
        StringBuilder sb = new StringBuilder();
        while ((line = br.readLine()) != null) {
            if ((line = line.trim()).startsWith("#") || line.isEmpty()) continue;
            sb.append(line);
            sb.append(' ');
        }
        br.close();
        return sb.toString();
    }
}

