#!/usr/bin/env python3
# This is a script to translaiterate Arabic in the Buckwalter tradition

uni2buck  = {
	"ا":"A",	
	"أ":">",
	"إ":"<",
	"آ":"|",
        "ء":"'",
        "ب":"b",
        "ت":"t",
        "ة":"p",
        "ث":"v",
        "ج":"j",
        "ح":"H",
        "خ":"x",
        "د":"d",
        "ذ":"*",
        "ر":"r",
        "ز":"z",
        "س":"s",
        "ش":"$",
        "ص":"S",
        "ض":"D",
        "ط":"T",
        "ظ":"Z",
        "ع":"E",

        "غ":"g",
        "ف":"f",
        "ق":"q",
        "ك":"k",
        "ل":"l",
        "م":"m",
        "ن":"n",
        "ه":"h",
        "و":"w",
	"ؤ":"&",
        "ي":"y",
        "ى":"Y",
	"ئ":"}",
        "":"",
        "،":",",
        "؟":"?",
        "؛":";",
        ".":".",
	"«":'"',
	"»":'"',

	"٠":"0",
	"١": "1",
	"٢": '2',
	"٣": '3',
	"٤": '4',
	"٥": '5',
	"٦": '6',
	"٧" : '7',
	"٨": '8',
	"٩": '9',

	"ً": 'F',
	"ٌ": 'N',
	"ٍ": 'K',
	"َ": 'a',
	"ُ": 'u',
	"ِ":'i',
	"ّ":'~',
	"ْ":'o',
	'\u0671' :'{',
	"`": ''

}

buck2uni = {v:k for k, v in uni2buck.items()}


def toBuck(word):
	return ''.join([uni2buck.get(letter, letter) for letter in word])

def toUnicode(word):
	return ''.join([buck2uni.get(letter, letter) for letter in word])


if __name__=="__main__":
# main
	message = """\n
****************************************************
Two arguments are needed: The first argument is either
ar : convert Buckwalter to Arabic, or
buck : convert Arabic to Buckwalter
For example: python3 ar file_in_buckwalter > new_file
****************************************************\n
"""

	import sys
	try:
		option = sys.argv[1]
		infile = open(sys.argv[2])

		for line in infile:
			if option == 'ar': # produce Arabic given a buckwalter file
				line = toUnicode(line)
			elif option == 'buck':
				line = toUnicode(line)
			print(line.strip())
	except IndexError:
		print(message)
