
functor PrettyFn (structure Os : sig type outstream val output : (outstream * string) -> unit end) : PRETTY where type outstream = Os.outstream = struct

    structure A = AbsPcf

    type outstream = Os.outstream

    val output = Os.output

    structure SimpleToken : PP_TOKEN = struct
        type token = string
	type style = unit
	fun string s = s
	fun style _ = ()
	val size = String.size
    end
    structure SimpleDevice : PP_DEVICE = struct
        type device = outstream
	type style = unit

	fun sameStyle _ = true

	fun pushStyle _ = ()

	fun popStyle _ = ()

	fun defaultStyle _ = ()

	fun depth _ = NONE

	fun lineWidth _ = SOME 80

	fun textWidth _ = SOME 72

	fun space (os, n) = output (os, String.implode (List.tabulate (n,(fn _ => #" "))))
	fun string (os, s) = output (os, s)
	fun char (os, c) = output (os, String.str c)
	fun newline os = char (os, #"\n")
	fun flush _ = ()
    end

    structure PP = PPStreamFn(structure Token = SimpleToken ;
			      structure Device = SimpleDevice)

    val prec_rec = 1
    val prec_arrow = 2


    val prec_top = 0
    val prec_abs = 1
    val prec_if = 1
    val prec_let = 1
    val prec_app = 3
    val prec_unop = 5
    val prec_const = 7

    fun lparen s prec myprec = 
	if myprec < prec then PP.string s "(" else ()

    fun rparen s prec myprec =
	if myprec < prec then PP.string s ")" else ()

    fun pretty_typ s = let
	val lparen = lparen s
	val rparen = rparen s
	fun pp (prec, (tp,info)) =
	    (PP.openHOVBox s (PP.Rel 2);
	     (case tp of
		 A.Unit => PP.string s "unit"
	       | A.Nat => PP.string s "nat" 
	       | A.Bool => PP.string s "bool"
	       | A.Arrow (tp1,tp2) =>
		 (lparen prec prec_arrow;
		  pp (prec_arrow+1, tp1) ; PP.space s 1;
		  PP.string s "->"; PP.space s 1;
		  pp (prec_arrow, tp2) ; 
		  rparen prec prec_arrow)
	       | A.Rec (nm, tp) =>
		 (lparen prec prec_rec ;
		  PP.string s "rec" ; PP.space s 1;
		  PP.string s nm ; PP.space s 1;
		  PP.string s "." ;
		  PP.openHOVBox s (PP.Rel 2) ;
		  PP.space s 1;
		  pp (prec_rec, tp) ;
		  PP.closeBox s;
		  rparen prec prec_rec)
	       | A.TyVar nm =>
		 PP.string s nm) ;
	     PP.closeBox s)
    in
	fn tp => pp (0,tp)
    end

    fun pretty os t = let
	val s = PP.openStream os
	val pt = pretty_typ s 
	val lparen = lparen s
	val rparen = rparen s
	fun pp (prec, (t,info)) = 
	    (PP.openHOVBox s (PP.Abs 2);
	     (case t of
		  A.Var nm =>
		  PP.string s nm
		| A.UnitVal =>
		  PP.string s "()"
		| A.True =>
		  PP.string s "true"
		| A.False =>
		  PP.string s "false"
		| A.IfThenElse (t1,t2,t3) =>
		  (lparen prec prec_if ;
		   PP.string s "if"; PP.space s 1;
		   pp (prec_if, t1) ; PP.space s 1;
		   PP.string s "then" ; PP.space s 1;
		   pp (prec_if, t2) ; PP.space s 1;
		   PP.string s "else" ; PP.space s 1;
		   pp (prec_if, t3) ;
		   rparen prec prec_if )
		| A.Zero => PP.string s "0"
		| A.Succ t' => 
		  (lparen prec prec_unop ;
		   PP.string s "succ" ; PP.space s 1;
		   pp (prec_unop, t');
		   rparen prec prec_unop)
		| A.Pred t' => 
		  (lparen prec prec_unop ;
		   PP.string s "pred" ; PP.space s 1;
		   pp (prec_unop, t');
		   rparen prec prec_unop)
		| A.IsZero t' => 
		  (lparen prec prec_unop ;
		   PP.string s "iszero" ; PP.space s 1;
		   pp (prec_unop, t');
		   rparen prec prec_unop)
		| A.Abs (nm,tp,t') =>
		  (lparen prec prec_abs ;
		   PP.string s "L"; PP.space s 1 ;
		   PP.string s nm;
		   PP.string s " : "; pt tp;
		   PP.string s "." ; PP.space s 1;
		   pp (prec_abs, t') ;
		   rparen prec prec_abs)
		| A.App (t1,t2) =>
		  (lparen prec prec_app ;
		   pp (prec_app, t1);
		   PP.space s 1;
		   pp (prec_app+1, t2);
		   rparen prec prec_app)
		| A.Roll (tp, t) =>
		  (lparen prec prec_unop ;
		   PP.string s "roll" ; PP.space s 1 ;
		   pt tp ; PP.space s 1 ;
		   pp (prec_unop, t) ;
		   rparen prec prec_unop)
		| A.Unroll t =>
		  (lparen prec prec_unop ;
		   PP.string s "unroll" ; PP.space s 1;
		   pp (prec_unop, t) ;
		   rparen prec prec_unop)
		| A.Let (binds, t) =>
		  (lparen prec prec_let ;
		   PP.openVBox s (PP.Rel 0);
		   PP.string s "let" ;
		   PP.openVBox s (PP.Abs 2);
		   PP.newline s;
		   List.app (fn (nm,tp, t) =>
				(PP.openHBox s ; PP.string s "val" ; PP.space s 1;
				 PP.string s nm ; PP.space s 1;
				 PP.string s ":" ; PP.space s 1;
				 pt tp ; PP.space s 1;
				 PP.string s "=" ; PP.space s 1;
				 pp (prec_top, t);
				 PP.closeBox s;
				 PP.newline s)) binds ;
		   PP.closeBox s;
		   PP.newline s;
		   PP.string s "in";
		   PP.openVBox s (PP.Abs 2) ; PP.newline s; PP.closeBox s;
		   pp (prec_let, t); PP.newline s;
		   PP.string s "end";
		   PP.closeBox s; 
		   rparen prec prec_let)
		) ;
	     PP.closeBox s)
    in
	pp (prec_top, t) ;
	PP.newline s ;
	PP.closeStream s
    end

end

structure Pretty = PrettyFn (structure Os = struct
			         type outstream = unit
				 fun output (_,s) = print s
			     end)
