
structure Parse :> PARSE =
   struct
      structure PcfLrVals = PcfLrValsFun (structure Token = LrParser.Token)
      structure LexUtil = LexUtilFun (structure Tokens = PcfLrVals.Tokens)
      structure PcfLex = PcfLexFun (structure LexUtil = LexUtil)
      structure PcfParser = Join (structure ParserData = PcfLrVals.ParserData
				  structure Lex = PcfLex
				  structure LrParser = LrParser)

      val lookahead = 15  (* suggested by ML-Yacc documentation *)

      exception ParseError of string * Location.loc

      fun signal_error (msg, pos1, pos2) = 
          raise (ParseError (msg, (pos1, pos2)))

      fun parse_f f =
	 let val lexer = PcfParser.makeLexer f
	 in
	    #1 (PcfParser.parse (lookahead, lexer, signal_error, ()))
	    handle PcfParser.ParseError => raise ParseError ("", Location.dummyloc)
	 end

      fun lex_f f =
	 let val lexer = PcfLex.makeLexer f
	     fun terminal (LrParser.Token.TOKEN (LrParser.LrTable.T n, _)) = n
	     val eof = terminal (PcfLrVals.Tokens.EOF (Location.dummypos, Location.dummypos))
	     fun loop l =
		(let val n = terminal (lexer ())
		 in
		    if n = eof then
		       rev l
		    else
		       loop (n :: l)
		 end
		 handle LexUtil.LexerError _ => rev l)
	 in
	    loop nil
	 end

      fun parse ins = parse_f (fn n => TextIO.inputN (ins, n))
      fun lex ins = lex_f (fn n => TextIO.inputN (ins, n))

      fun str_reader s = let
	  val z = size s
	  val pos = ref 0
      in
	  fn n => if !pos >= z then "" else
		  if !pos+n >= z then let
			  val s' = String.extract (s,!pos,NONE)
		      in
			  pos := z ; s'
		      end
		  else let
			  val s' = String.extract (s,!pos, SOME n)
			  val pos' = !pos + n
		      in
			  pos := pos' ; s'
		      end
      end
	  
      fun parse_str s = parse_f (str_reader s)
      fun lex_str s = lex_f (str_reader s)

   end
