
functor NamedFn (structure Lambda : LAMBDA) :> NAMED where L = Lambda = struct

    structure A = AbsPcf
    structure L = Lambda

    type identifier = A.identifier
    type info = LambdaInfo.info

    type context = int * (identifier list)

    val empty_context = (0, [])

    fun lookup (z, ctx) i = List.nth (ctx, i)

    fun extend (z, ctx) nm = (1+z, (nm ^ (Int.toString z))::ctx)

    fun sizeof_context (z,_) = z

    exception InconsistentTypeVariable of int * int * int

    fun named_typ ctx tp = 
	case tp of
	    L.Unit => (A.Unit, LambdaInfo.dummyinfo)
	  | L.Bool => (A.Bool, LambdaInfo.dummyinfo)
	  | L.Nat => (A.Nat, LambdaInfo.dummyinfo)
	  | L.Arrow (tp1, tp2) => (A.Arrow (named_typ ctx tp1, named_typ ctx tp2), LambdaInfo.dummyinfo)
	  | L.Rec (str, tp) => let
		val ctx' = extend ctx str
	    in
		(A.Rec (lookup ctx' 0, named_typ ctx' tp), LambdaInfo.dummyinfo)
	    end
	  | L.TyVar (i,n) =>
	    if (sizeof_context ctx) <> n then
		raise (InconsistentTypeVariable (i, (sizeof_context ctx), n))
	    else 
		(A.TyVar (lookup ctx i), LambdaInfo.dummyinfo)



    exception InconsistentVariable of int * int * int * info

    fun named ctx = let
	val look = lookup ctx
	val ex = extend ctx
	fun nm (t: L.term_,info) =
	    case t of
		L.Var (i,n) => if (sizeof_context ctx) <> n
				 then raise (InconsistentVariable (i, (sizeof_context ctx), n, info))
				 else (A.Var (look i), info)
	      | L.UnitVal => (A.UnitVal, info)
	      | L.True => (A.True, info)
	      | L.False => (A.False, info)
	      | L.IfThenElse (t1,t2,t3) => (A.IfThenElse (nm t1, nm t2, nm t3), info)
	      | L.Zero => (A.Zero, info)
	      | L.Succ t' => (A.Succ (nm t'), info)
	      | L.Pred t' => (A.Pred (nm t'), info)
	      | L.IsZero t' => (A.IsZero (nm t'), info)
	      | L.Abs (nm,tp,t') => let
		    val ctx' = ex nm
		    val nm' = lookup ctx' 0 (*because of renaming*)
		in
		    (A.Abs (nm', named_typ empty_context tp, named ctx' t'), info)
		end
	      | L.App (t1,t2) => (A.App (nm t1, nm t2), info)
	      | L.Roll (tp, t) => 
		(A.Roll (named_typ empty_context tp, nm t), info)
	      | L.Unroll t =>
		(A.Unroll (nm t), info)
    in
	nm
    end
		    
end
