
structure Lambda : LAMBDA = struct
    val name : string = "Aleksey Kliger" (* your name *)
    val email : string = "aleksey@cs.cmu.edu" (* your email *)

    type info = LambdaInfo.info

    datatype typ = Unit | Bool | Nat | Arrow of typ * typ
		 | TyVar of int * int
		 | Rec of string * typ

    datatype term_ = Var of int * int       (* index, ctx *)
		   | UnitVal
		   | True 
		   | False
		   | IfThenElse of term * term * term
		   | Zero
		   | Succ of term
		   | Pred of term
		   | IsZero of term
		   | Abs of string * typ * term
		   | App of term * term
		   | Roll of typ * term
		   | Unroll of term
    withtype term = term_ * info

    exception Unimplemented of string
    fun unimplemented s = raise (Unimplemented s)

    fun type_shift (d,t) = unimplemented "type_shift"

    fun type_subst(j,s,t) = unimplemented "type_subst"

    fun type_eq (t1,t2) = unimplemented "type_eq"

     (* shift (d,t) returns t with free variables shifted by d *)
    fun shift (d,t) = let
	fun walk (n,(t,info)) =
	    case t of
		Var (i,l) => if (i < n) then (Var(i,l+d),info) else (Var (i+d,l+d),info)
	      | IfThenElse (t1,t2,t3) => (IfThenElse (walk (n,t1),walk (n,t2),walk (n,t3)), info)
	      | Succ t' => (Succ (walk (n,t')), info)
	      | Pred t' => (Pred (walk (n,t')), info)
	      | IsZero t' => (IsZero (walk (n,t')), info)
	      | Abs (s,tp,t') => (Abs (s,tp, walk (n+1, t')), info)
	      | App (t1,t2) => (App (walk (n,t1), walk (n,t2)), info)
	      | Roll (tp,t) => (Roll (tp, walk (n,t)), info)
	      | Unroll t => (Unroll (walk (n,t)), info)
	      | _ => (t,info)
    in
	walk (0,t)
    end

     (* subst (j,s,t) returns t[s/j] *)
    fun subst (j,s,t) = let
	fun walk (n,(t,info)) =
	    case t of
		Var (i,l) => if i = j+n then shift (n,s) else (Var (i,l), info)
	      | IfThenElse (t1,t2,t3) => (IfThenElse (walk (n,t1), walk (n,t2), walk (n,t3)), info)
	      | Succ t' => (Succ (walk (n,t')), info)
	      | Pred t' => (Pred (walk (n,t')), info)
	      | IsZero t' => (IsZero (walk (n,t')), info)
	      | Abs (s,tp,t') => (Abs (s,tp, walk (n+1, t')), info)
	      | App (t1,t2) => (App (walk (n, t1), walk (n, t2)), info)
	      | Roll (tp, t) => (Roll (tp, walk (n,t)), info)
	      | Unroll t => (Unroll (walk (n,t)), info)
	      | _ => (t,info)
    in
	walk (0,t)
    end

    fun substTop (s,t) = shift (~1, subst(0,shift (1,s),t))

    fun isval (t,info) = let
	fun isnumericval (t,info) =
	    case t of
		Zero => true
	      | Succ t' => isnumericval t'
	      | _ => false
    in
	case t of
	  UnitVal => true
	| True => true
	| False => true
	| Zero => true
	| Succ t => isnumericval t
	| Abs _ => true
	| Roll (_,t) => unimplemented "isval for roll"
	| _ => false
    end
			
    type context = typ list

    exception TypeError of string * info

    fun unroll_type t = unimplemented "unroll"

    val empty_context = []

    fun lookup ctx i = List.nth (ctx, i)

    fun extend ctx tp = tp::ctx

    fun typecheck ctx = let
	val look = lookup ctx
	val ex = extend ctx
	fun tc (t,info) = 
	    case t of
		Var (i,n) => look i
	      | UnitVal => Unit
	      | True => Bool
	      | False => Bool
	      | IfThenElse (t1,t2,t3) =>
		(case tc t1 of
		     Bool => let
			 val tp2 = tc t2
			 val tp3 = tc t3
		 in
			 if type_eq (tp2,tp3) then tp2
			 else raise (TypeError ("arms of if-then-else have differen types", info))
		     end
		   | _ => raise (TypeError ("condition of if-then-else not a boolean", info)))
	      | Zero => Nat
	      | Succ t' => 
		(case tc t' of
		     Nat => Nat
		   | _ => raise (TypeError ("successor of non-Nat", info)))
	      | Pred t' =>
		(case tc t' of
		     Nat => Nat
		   | _ => raise (TypeError ("predecessor of non-Nat", info)))
	      | IsZero t' =>
		(case tc t' of
		     Nat => Bool
		   | _ => raise (TypeError ("isZero of non-Nat", info)))
	      | Abs (s,tp,t') => let
		    val tp' = typecheck (ex tp) t'
		in
		    Arrow (tp,tp')
		end
	      | App (t1,t2) =>
		(case tc t1 of
		     Arrow (tp11,tp12) => let
			 val tp2 = tc t2
		     in
			 if type_eq (tp11, tp2) then tp12
			 else raise (TypeError ("application argument doesn't match function domain", info))
		     end
		   | _ => raise (TypeError ("application of non-function", info)))
	      | Roll (tp,t) => unimplemented "typecheck for roll"
	      | Unroll t => unimplemented "typecheck for unroll"
    in
	tc
    end
		
		
    exception NoRuleApplies

    fun eval (t,info) = 
	case t of
	    Var _ => raise NoRuleApplies
	  | IfThenElse (t1,t2,t3) => 
	    (case eval t1 of
		 (True,_) => eval t2
	       | (False,_) => eval t3
	       | _ => raise NoRuleApplies)
	  | Succ t' => (Succ (eval t'),info)
	  | Pred t' =>
	    (case eval t' of
		 (Zero,_) => (Zero,info)
	       | (Succ t'',_) => t''
	       | _ => raise NoRuleApplies)
	  | IsZero t' =>
	    (case eval t' of
		 (Zero, _) => (True,info)
	       | (Succ _, _) => (False, info)
	       | _ => raise NoRuleApplies)
	  | App (t1,t2) =>
	    (case eval t1 of
		 (Abs (_,_,t'), _) => let
		     val v2 = eval t2
		 in 
		     eval (substTop (v2,t'))
		 end
	       | _ => raise NoRuleApplies)
	  | Roll (tp, t) => unimplemented "eval for roll"
	  | Unroll t => unimplemented "eval for unroll"
	  | _ => (t,info)

end