signature LAMBDA = sig
    val name : string (* your name *)
    val email : string (* your email *)

    type info = LambdaInfo.info

    datatype typ = Unit | Bool | Nat | Arrow of typ * typ
		 | TyVar of int * int
		 | Rec of string * typ

    datatype term_ = Var of int * int       (* index, ctx *)
		   | UnitVal
		   | True 
		   | False
		   | IfThenElse of term * term * term
		   | Zero
		   | Succ of term
		   | Pred of term
		   | IsZero of term
		   | Abs of string * typ * term
		   | App of term * term
		   | Roll of typ * term
		   | Unroll of term

    withtype term = term_ * info

    exception Unimplemented of string

    val type_shift : int * typ -> typ

    val type_subst : int * typ * typ -> typ

    val type_eq : typ * typ -> bool

    val unroll_type : typ -> typ option (* return NONE if not a Rec type *)

     (* shift (d,t) returns t with free variables shifted by d *)
    val shift : int * term -> term

     (* subst (j,s,t) returns t[s/j] *)
    val subst : int * term * term -> term

    val isval : term -> bool

    type context = typ list

    exception TypeError of string * info

    val empty_context : context

    val lookup : context -> int -> typ

    val extend : context -> typ -> context

    val typecheck : context -> term -> typ

    exception NoRuleApplies

    val eval : term -> term
end