
structure Error :> ERROR =
   struct
      (*open Print*)
      fun newline () = print "\n"
      fun flush () = ()

      exception Error

      fun print_context (pos1 as (col1, ln1), pos2 as (col2, ln2)) =
          if pos1 = Location.dummypos then
             ()
          else
             (
             print "at location ";
             print (Int.toString ln1); print ":" ; print (Int.toString col1);
             if pos2 = Location.dummypos orelse pos1 = pos2 then
                ()
             else
                (
                print "-";
                print (Int.toString ln2) ; print ":" ; print (Int.toString col2)
                );
             newline ()
             )

      val current_label : (unit -> string) option ref = ref NONE

      fun signal_error loc str detail =
          (
          print "Error: ";
          print str;
          newline ();
          detail ();
          print_context loc;
          (case !current_label of
              NONE => ()
            | SOME sym =>
                 (
                 print "while checking label ";
                 print (sym ());
                 newline ()
                 ));
          flush ();
          raise Error
          )

      fun set_current_label sym = current_label := SOME sym
      fun set_no_current_label () = current_label := NONE

      fun unimplemented loc s = signal_error loc (s ^ " are unimplemented") (fn _ => ())

      exception Bug of string
      fun bug s = raise (Bug s)
   end
