
structure AbsPcf = struct

type identifier = string

datatype typ_ = TyVar of identifier | Nat | Bool | Unit | Arrow of typ * typ
	      (*| Sum of typ * typ | Prod of typ * typ*)
	      | Rec of identifier * typ

withtype typ = typ_ * Location.loc

datatype exp_ = Var of identifier
	      | UnitVal
	      | True | False
	      | IfThenElse of exp * exp * exp
	      | Zero | Succ of exp
	      | Pred of exp | IsZero of exp
	      | Abs of identifier * typ * exp
	      | App of exp * exp
	      (* | Fix of identifier * typ * exp*)
	      | Let of (identifier * typ * exp) list * exp (*derived syntax*)
	      (* | Inl of typ * exp
	      | Inr of typ * exp
	      | Case of exp * identifier * exp * identifier * exp *)
	      (* | Tuple of exp * exp
	      | Proj of int * exp (* int "should be" 1 or 2 *) *)
	      | Roll of typ * exp
	      | Unroll of exp

withtype exp = exp_ * Location.loc

end